/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.InitiateVaultLockRequest;
import com.amazonaws.services.glacier.model.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class InitiateVaultLockRequestMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<StructuredPojo> POLICY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).build();
    private static final InitiateVaultLockRequestMarshaller instance = new InitiateVaultLockRequestMarshaller();

    public static InitiateVaultLockRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(InitiateVaultLockRequest initiateVaultLockRequest, ProtocolMarshaller protocolMarshaller) {
        if (initiateVaultLockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(initiateVaultLockRequest.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(initiateVaultLockRequest.getVaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall(initiateVaultLockRequest.getPolicy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

