/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class LoadBalancerAvailable {
    LoadBalancerAvailable() {
    }

    static class IsLoadBalancerNotFoundMatcher
    extends WaiterAcceptor<DescribeLoadBalancersResult> {
        IsLoadBalancerNotFoundMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "LoadBalancerNotFound".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsProvisioningMatcher
    extends WaiterAcceptor<DescribeLoadBalancersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsProvisioningMatcher() {
        }

        @Override
        public boolean matches(DescribeLoadBalancersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"provisioning\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("LoadBalancers")), new JmesPathSubExpression(new JmesPathField("State"), new JmesPathField("Code")));
        }
    }

    static class IsActiveMatcher
    extends WaiterAcceptor<DescribeLoadBalancersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsActiveMatcher() {
        }

        @Override
        public boolean matches(DescribeLoadBalancersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"active\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("LoadBalancers")), new JmesPathSubExpression(new JmesPathField("State"), new JmesPathField("Code")));
        }
    }
}

