/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RunInstancesRequestMarshaller
implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {
    @Override
    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {
        SdkInternalList runInstancesRequestTagSpecificationsList;
        SdkInternalList runInstancesRequestNetworkInterfacesList;
        IamInstanceProfileSpecification iamInstanceProfile;
        SdkInternalList runInstancesRequestSecurityGroupsList;
        SdkInternalList runInstancesRequestSecurityGroupIdsList;
        Placement placement;
        SdkInternalList runInstancesRequestIpv6AddressesList;
        if (runInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RunInstancesRequest> request = new DefaultRequest<RunInstancesRequest>(runInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList runInstancesRequestBlockDeviceMappingsList = (SdkInternalList)runInstancesRequest.getBlockDeviceMappings();
        if (!runInstancesRequestBlockDeviceMappingsList.isEmpty() || !runInstancesRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (Object runInstancesRequestBlockDeviceMappingsListValue : runInstancesRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getDeviceName()));
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getVirtualName()));
                }
                if ((ebs = ((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getEbs()) != null) {
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.getEncrypted()));
                    }
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.getIops()));
                    }
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebs.getVolumeType()));
                    }
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (runInstancesRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(runInstancesRequest.getImageId()));
        }
        if (runInstancesRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(runInstancesRequest.getInstanceType()));
        }
        if (runInstancesRequest.getIpv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger(runInstancesRequest.getIpv6AddressCount()));
        }
        if (!(runInstancesRequestIpv6AddressesList = (SdkInternalList)runInstancesRequest.getIpv6Addresses()).isEmpty() || !runInstancesRequestIpv6AddressesList.isAutoConstruct()) {
            int ipv6AddressesListIndex = 1;
            for (InstanceIpv6Address runInstancesRequestIpv6AddressesListValue : runInstancesRequestIpv6AddressesList) {
                if (runInstancesRequestIpv6AddressesListValue.getIpv6Address() != null) {
                    request.addParameter("Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString(runInstancesRequestIpv6AddressesListValue.getIpv6Address()));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (runInstancesRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(runInstancesRequest.getKernelId()));
        }
        if (runInstancesRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(runInstancesRequest.getKeyName()));
        }
        if (runInstancesRequest.getMaxCount() != null) {
            request.addParameter("MaxCount", StringUtils.fromInteger(runInstancesRequest.getMaxCount()));
        }
        if (runInstancesRequest.getMinCount() != null) {
            request.addParameter("MinCount", StringUtils.fromInteger(runInstancesRequest.getMinCount()));
        }
        if (runInstancesRequest.getMonitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringUtils.fromBoolean(runInstancesRequest.getMonitoring()));
        }
        if ((placement = runInstancesRequest.getPlacement()) != null) {
            if (placement.getAvailabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
            }
            if (placement.getAffinity() != null) {
                request.addParameter("Placement.Affinity", StringUtils.fromString(placement.getAffinity()));
            }
            if (placement.getGroupName() != null) {
                request.addParameter("Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
            }
            if (placement.getHostId() != null) {
                request.addParameter("Placement.HostId", StringUtils.fromString(placement.getHostId()));
            }
            if (placement.getTenancy() != null) {
                request.addParameter("Placement.Tenancy", StringUtils.fromString(placement.getTenancy()));
            }
            if (placement.getSpreadDomain() != null) {
                request.addParameter("Placement.SpreadDomain", StringUtils.fromString(placement.getSpreadDomain()));
            }
        }
        if (runInstancesRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(runInstancesRequest.getRamdiskId()));
        }
        if (!(runInstancesRequestSecurityGroupIdsList = (SdkInternalList)runInstancesRequest.getSecurityGroupIds()).isEmpty() || !runInstancesRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (Object runInstancesRequestSecurityGroupIdsListValue : runInstancesRequestSecurityGroupIdsList) {
                if (runInstancesRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)runInstancesRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (!(runInstancesRequestSecurityGroupsList = (SdkInternalList)runInstancesRequest.getSecurityGroups()).isEmpty() || !runInstancesRequestSecurityGroupsList.isAutoConstruct()) {
            int securityGroupsListIndex = 1;
            for (String runInstancesRequestSecurityGroupsListValue : runInstancesRequestSecurityGroupsList) {
                if (runInstancesRequestSecurityGroupsListValue != null) {
                    request.addParameter("SecurityGroup." + securityGroupsListIndex, StringUtils.fromString(runInstancesRequestSecurityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (runInstancesRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString(runInstancesRequest.getSubnetId()));
        }
        if (runInstancesRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString(runInstancesRequest.getUserData()));
        }
        if (runInstancesRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString(runInstancesRequest.getAdditionalInfo()));
        }
        if (runInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(runInstancesRequest.getClientToken()));
        }
        if (runInstancesRequest.getDisableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringUtils.fromBoolean(runInstancesRequest.getDisableApiTermination()));
        }
        if (runInstancesRequest.getEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean(runInstancesRequest.getEbsOptimized()));
        }
        if ((iamInstanceProfile = runInstancesRequest.getIamInstanceProfile()) != null) {
            if (iamInstanceProfile.getArn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.getArn()));
            }
            if (iamInstanceProfile.getName() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.getName()));
            }
        }
        if (runInstancesRequest.getInstanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior", StringUtils.fromString(runInstancesRequest.getInstanceInitiatedShutdownBehavior()));
        }
        if (!(runInstancesRequestNetworkInterfacesList = (SdkInternalList)runInstancesRequest.getNetworkInterfaces()).isEmpty() || !runInstancesRequestNetworkInterfacesList.isAutoConstruct()) {
            int networkInterfacesListIndex = 1;
            for (InstanceNetworkInterfaceSpecification runInstancesRequestNetworkInterfacesListValue : runInstancesRequestNetworkInterfacesList) {
                SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                SdkInternalList instanceNetworkInterfaceSpecificationGroupsList;
                if (runInstancesRequestNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean(runInstancesRequestNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean(runInstancesRequestNetworkInterfacesListValue.getDeleteOnTermination()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDescription() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString(runInstancesRequestNetworkInterfacesListValue.getDescription()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDeviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger(runInstancesRequestNetworkInterfacesListValue.getDeviceIndex()));
                }
                if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)runInstancesRequestNetworkInterfacesListValue.getGroups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                    int groupsListIndex = 1;
                    for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                        if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                        }
                        ++groupsListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger(runInstancesRequestNetworkInterfacesListValue.getIpv6AddressCount()));
                }
                if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)runInstancesRequestNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                    Object instanceNetworkInterfaceSpecificationGroupsListValue;
                    int ipv6AddressesListIndex = 1;
                    instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                    while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                        InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                        if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString(instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address()));
                        }
                        ++ipv6AddressesListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString(runInstancesRequestNetworkInterfacesListValue.getNetworkInterfaceId()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString(runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddress()));
                }
                if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                    int privateIpAddressesListIndex = 1;
                    for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary()));
                        }
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress()));
                        }
                        ++privateIpAddressesListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger(runInstancesRequestNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getSubnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString(runInstancesRequestNetworkInterfacesListValue.getSubnetId()));
                }
                ++networkInterfacesListIndex;
            }
        }
        if (runInstancesRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString(runInstancesRequest.getPrivateIpAddress()));
        }
        if (!(runInstancesRequestTagSpecificationsList = (SdkInternalList)runInstancesRequest.getTagSpecifications()).isEmpty() || !runInstancesRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification runInstancesRequestTagSpecificationsListValue : runInstancesRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (runInstancesRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(runInstancesRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)runInstancesRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

