/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.BuildConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class BuildConfigurationStaxUnmarshaller
implements Unmarshaller<BuildConfiguration, StaxUnmarshallerContext> {
    private static BuildConfigurationStaxUnmarshaller instance;

    @Override
    public BuildConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return buildConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ArtifactName", targetDepth)) {
                    buildConfiguration.setArtifactName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CodeBuildServiceRole", targetDepth)) {
                    buildConfiguration.setCodeBuildServiceRole(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ComputeType", targetDepth)) {
                    buildConfiguration.setComputeType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Image", targetDepth)) {
                    buildConfiguration.setImage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TimeoutInMinutes", targetDepth)) continue;
                buildConfiguration.setTimeoutInMinutes(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return buildConfiguration;
    }

    public static BuildConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BuildConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

