/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeNetworkInterfacesRequestMarshaller
implements Marshaller<Request<DescribeNetworkInterfacesRequest>, DescribeNetworkInterfacesRequest> {
    @Override
    public Request<DescribeNetworkInterfacesRequest> marshall(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        SdkInternalList describeNetworkInterfacesRequestNetworkInterfaceIdsList;
        if (describeNetworkInterfacesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeNetworkInterfacesRequest> request = new DefaultRequest<DescribeNetworkInterfacesRequest>(describeNetworkInterfacesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeNetworkInterfaces");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeNetworkInterfacesRequestFiltersList = (SdkInternalList)describeNetworkInterfacesRequest.getFilters();
        if (!describeNetworkInterfacesRequestFiltersList.isEmpty() || !describeNetworkInterfacesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeNetworkInterfacesRequestFiltersListValue : describeNetworkInterfacesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeNetworkInterfacesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeNetworkInterfacesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeNetworkInterfacesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeNetworkInterfacesRequestNetworkInterfaceIdsList = (SdkInternalList)describeNetworkInterfacesRequest.getNetworkInterfaceIds()).isEmpty() || !describeNetworkInterfacesRequestNetworkInterfaceIdsList.isAutoConstruct()) {
            int networkInterfaceIdsListIndex = 1;
            for (String describeNetworkInterfacesRequestNetworkInterfaceIdsListValue : describeNetworkInterfacesRequestNetworkInterfaceIdsList) {
                if (describeNetworkInterfacesRequestNetworkInterfaceIdsListValue != null) {
                    request.addParameter("NetworkInterfaceId." + networkInterfaceIdsListIndex, StringUtils.fromString(describeNetworkInterfacesRequestNetworkInterfaceIdsListValue));
                }
                ++networkInterfaceIdsListIndex;
            }
        }
        return request;
    }
}

