/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.DefaultMessage;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DefaultMessageJsonUnmarshaller
implements Unmarshaller<DefaultMessage, JsonUnmarshallerContext> {
    private static DefaultMessageJsonUnmarshaller instance;

    @Override
    public DefaultMessage unmarshall(JsonUnmarshallerContext context) throws Exception {
        DefaultMessage defaultMessage = new DefaultMessage();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    defaultMessage.setBody(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Substitutions", targetDepth)) {
                    context.nextToken();
                    defaultMessage.setSubstitutions(new MapUnmarshaller(context.getUnmarshaller(String.class), new ListUnmarshaller<String>(context.getUnmarshaller(String.class))).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return defaultMessage;
    }

    public static DefaultMessageJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DefaultMessageJsonUnmarshaller();
        }
        return instance;
    }
}

