/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteBandwidthRateLimitRequestMarshaller
implements Marshaller<Request<DeleteBandwidthRateLimitRequest>, DeleteBandwidthRateLimitRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteBandwidthRateLimitRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteBandwidthRateLimitRequest> marshall(DeleteBandwidthRateLimitRequest deleteBandwidthRateLimitRequest) {
        if (deleteBandwidthRateLimitRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBandwidthRateLimitRequest> request = new DefaultRequest<DeleteBandwidthRateLimitRequest>(deleteBandwidthRateLimitRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.DeleteBandwidthRateLimit");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteBandwidthRateLimitRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(deleteBandwidthRateLimitRequest.getGatewayARN());
            }
            if (deleteBandwidthRateLimitRequest.getBandwidthType() != null) {
                jsonGenerator.writeFieldName("BandwidthType").writeValue(deleteBandwidthRateLimitRequest.getBandwidthType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

