/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.KinesisAction;

public class KinesisActionJsonMarshaller {
    private static KinesisActionJsonMarshaller instance;

    public void marshall(KinesisAction kinesisAction, StructuredJsonGenerator jsonGenerator) {
        if (kinesisAction == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (kinesisAction.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(kinesisAction.getRoleArn());
            }
            if (kinesisAction.getStreamName() != null) {
                jsonGenerator.writeFieldName("streamName").writeValue(kinesisAction.getStreamName());
            }
            if (kinesisAction.getPartitionKey() != null) {
                jsonGenerator.writeFieldName("partitionKey").writeValue(kinesisAction.getPartitionKey());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KinesisActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KinesisActionJsonMarshaller();
        }
        return instance;
    }
}

