/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.DynamoDBAction;

public class DynamoDBActionJsonMarshaller {
    private static DynamoDBActionJsonMarshaller instance;

    public void marshall(DynamoDBAction dynamoDBAction, StructuredJsonGenerator jsonGenerator) {
        if (dynamoDBAction == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (dynamoDBAction.getTableName() != null) {
                jsonGenerator.writeFieldName("tableName").writeValue(dynamoDBAction.getTableName());
            }
            if (dynamoDBAction.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(dynamoDBAction.getRoleArn());
            }
            if (dynamoDBAction.getOperation() != null) {
                jsonGenerator.writeFieldName("operation").writeValue(dynamoDBAction.getOperation());
            }
            if (dynamoDBAction.getHashKeyField() != null) {
                jsonGenerator.writeFieldName("hashKeyField").writeValue(dynamoDBAction.getHashKeyField());
            }
            if (dynamoDBAction.getHashKeyValue() != null) {
                jsonGenerator.writeFieldName("hashKeyValue").writeValue(dynamoDBAction.getHashKeyValue());
            }
            if (dynamoDBAction.getHashKeyType() != null) {
                jsonGenerator.writeFieldName("hashKeyType").writeValue(dynamoDBAction.getHashKeyType());
            }
            if (dynamoDBAction.getRangeKeyField() != null) {
                jsonGenerator.writeFieldName("rangeKeyField").writeValue(dynamoDBAction.getRangeKeyField());
            }
            if (dynamoDBAction.getRangeKeyValue() != null) {
                jsonGenerator.writeFieldName("rangeKeyValue").writeValue(dynamoDBAction.getRangeKeyValue());
            }
            if (dynamoDBAction.getRangeKeyType() != null) {
                jsonGenerator.writeFieldName("rangeKeyType").writeValue(dynamoDBAction.getRangeKeyType());
            }
            if (dynamoDBAction.getPayloadField() != null) {
                jsonGenerator.writeFieldName("payloadField").writeValue(dynamoDBAction.getPayloadField());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DynamoDBActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DynamoDBActionJsonMarshaller();
        }
        return instance;
    }
}

