/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.services.glacier.model.UploadListElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMultipartUploadsResult
implements Serializable,
Cloneable {
    private List<UploadListElement> uploadsList;
    private String marker;

    public List<UploadListElement> getUploadsList() {
        return this.uploadsList;
    }

    public void setUploadsList(Collection<UploadListElement> uploadsList) {
        if (uploadsList == null) {
            this.uploadsList = null;
            return;
        }
        this.uploadsList = new ArrayList<UploadListElement>(uploadsList);
    }

    public ListMultipartUploadsResult withUploadsList(UploadListElement ... uploadsList) {
        if (this.uploadsList == null) {
            this.setUploadsList(new ArrayList<UploadListElement>(uploadsList.length));
        }
        for (UploadListElement ele : uploadsList) {
            this.uploadsList.add(ele);
        }
        return this;
    }

    public ListMultipartUploadsResult withUploadsList(Collection<UploadListElement> uploadsList) {
        this.setUploadsList(uploadsList);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListMultipartUploadsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUploadsList() != null) {
            sb.append("UploadsList: " + this.getUploadsList() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResult)) {
            return false;
        }
        ListMultipartUploadsResult other = (ListMultipartUploadsResult)obj;
        if (other.getUploadsList() == null ^ this.getUploadsList() == null) {
            return false;
        }
        if (other.getUploadsList() != null && !other.getUploadsList().equals(this.getUploadsList())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUploadsList() == null ? 0 : this.getUploadsList().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListMultipartUploadsResult clone() {
        try {
            return (ListMultipartUploadsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

