/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.UserType;
import com.amazonaws.services.cognitoidp.model.transform.AttributeTypeJsonMarshaller;
import java.util.List;

public class UserTypeJsonMarshaller {
    private static UserTypeJsonMarshaller instance;

    public void marshall(UserType userType, StructuredJsonGenerator jsonGenerator) {
        if (userType == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttributeType> attributesList;
            jsonGenerator.writeStartObject();
            if (userType.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(userType.getUsername());
            }
            if ((attributesList = userType.getAttributes()) != null) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartArray();
                for (AttributeType attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (userType.getUserCreateDate() != null) {
                jsonGenerator.writeFieldName("UserCreateDate").writeValue(userType.getUserCreateDate());
            }
            if (userType.getUserLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("UserLastModifiedDate").writeValue(userType.getUserLastModifiedDate());
            }
            if (userType.getEnabled() != null) {
                jsonGenerator.writeFieldName("Enabled").writeValue(userType.getEnabled());
            }
            if (userType.getUserStatus() != null) {
                jsonGenerator.writeFieldName("UserStatus").writeValue(userType.getUserStatus());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static UserTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UserTypeJsonMarshaller();
        }
        return instance;
    }
}

