/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.services.simpledb.model.DeletableItem;
import com.amazonaws.services.simpledb.model.transform.AttributeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DeletableItemStaxUnmarshaller
implements Unmarshaller<DeletableItem, StaxUnmarshallerContext> {
    private static DeletableItemStaxUnmarshaller instance;

    @Override
    public DeletableItem unmarshall(StaxUnmarshallerContext context) throws Exception {
        DeletableItem deletableItem = new DeletableItem();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return deletableItem;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ItemName", targetDepth)) {
                    deletableItem.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Attribute", targetDepth)) continue;
                deletableItem.withAttributes(AttributeStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return deletableItem;
    }

    public static DeletableItemStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DeletableItemStaxUnmarshaller();
        }
        return instance;
    }
}

