/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.FaceMatch;

@SdkInternalApi
public class FaceMatchMarshaller {
    private static final MarshallingInfo<Float> SIMILARITY_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Similarity").build();
    private static final MarshallingInfo<StructuredPojo> FACE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Face").build();
    private static final FaceMatchMarshaller instance = new FaceMatchMarshaller();

    public static FaceMatchMarshaller getInstance() {
        return instance;
    }

    public void marshall(FaceMatch faceMatch, ProtocolMarshaller protocolMarshaller) {
        if (faceMatch == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(faceMatch.getSimilarity(), SIMILARITY_BINDING);
            protocolMarshaller.marshall(faceMatch.getFace(), FACE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

