/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesis.model.EnhancedMetrics;
import java.util.List;

@SdkInternalApi
public class EnhancedMetricsMarshaller {
    private static final MarshallingInfo<List> SHARDLEVELMETRICS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardLevelMetrics").build();
    private static final EnhancedMetricsMarshaller instance = new EnhancedMetricsMarshaller();

    public static EnhancedMetricsMarshaller getInstance() {
        return instance;
    }

    public void marshall(EnhancedMetrics enhancedMetrics, ProtocolMarshaller protocolMarshaller) {
        if (enhancedMetrics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(enhancedMetrics.getShardLevelMetrics(), SHARDLEVELMETRICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

