/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.machinelearning.AmazonMachineLearningAsync;
import com.amazonaws.services.machinelearning.AmazonMachineLearningAsyncClientBuilder;
import com.amazonaws.services.machinelearning.AmazonMachineLearningClient;
import com.amazonaws.services.machinelearning.model.AddTagsRequest;
import com.amazonaws.services.machinelearning.model.AddTagsResult;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Request;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Result;
import com.amazonaws.services.machinelearning.model.CreateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.CreateEvaluationResult;
import com.amazonaws.services.machinelearning.model.CreateMLModelRequest;
import com.amazonaws.services.machinelearning.model.CreateMLModelResult;
import com.amazonaws.services.machinelearning.model.CreateRealtimeEndpointRequest;
import com.amazonaws.services.machinelearning.model.CreateRealtimeEndpointResult;
import com.amazonaws.services.machinelearning.model.DeleteBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.DeleteBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.DeleteDataSourceRequest;
import com.amazonaws.services.machinelearning.model.DeleteDataSourceResult;
import com.amazonaws.services.machinelearning.model.DeleteEvaluationRequest;
import com.amazonaws.services.machinelearning.model.DeleteEvaluationResult;
import com.amazonaws.services.machinelearning.model.DeleteMLModelRequest;
import com.amazonaws.services.machinelearning.model.DeleteMLModelResult;
import com.amazonaws.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import com.amazonaws.services.machinelearning.model.DeleteRealtimeEndpointResult;
import com.amazonaws.services.machinelearning.model.DeleteTagsRequest;
import com.amazonaws.services.machinelearning.model.DeleteTagsResult;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsRequest;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsResult;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesRequest;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesResult;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsRequest;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsResult;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsRequest;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsResult;
import com.amazonaws.services.machinelearning.model.DescribeTagsRequest;
import com.amazonaws.services.machinelearning.model.DescribeTagsResult;
import com.amazonaws.services.machinelearning.model.GetBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.GetBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.GetDataSourceRequest;
import com.amazonaws.services.machinelearning.model.GetDataSourceResult;
import com.amazonaws.services.machinelearning.model.GetEvaluationRequest;
import com.amazonaws.services.machinelearning.model.GetEvaluationResult;
import com.amazonaws.services.machinelearning.model.GetMLModelRequest;
import com.amazonaws.services.machinelearning.model.GetMLModelResult;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.services.machinelearning.model.PredictResult;
import com.amazonaws.services.machinelearning.model.UpdateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.UpdateBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.UpdateDataSourceRequest;
import com.amazonaws.services.machinelearning.model.UpdateDataSourceResult;
import com.amazonaws.services.machinelearning.model.UpdateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.UpdateEvaluationResult;
import com.amazonaws.services.machinelearning.model.UpdateMLModelRequest;
import com.amazonaws.services.machinelearning.model.UpdateMLModelResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMachineLearningAsyncClient
extends AmazonMachineLearningClient
implements AmazonMachineLearningAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonMachineLearningAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonMachineLearningAsyncClientBuilder asyncBuilder() {
        return AmazonMachineLearningAsyncClientBuilder.standard();
    }

    AmazonMachineLearningAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        final AddTagsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeAddTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBatchPredictionResult> createBatchPredictionAsync(CreateBatchPredictionRequest request) {
        return this.createBatchPredictionAsync(request, null);
    }

    @Override
    public Future<CreateBatchPredictionResult> createBatchPredictionAsync(CreateBatchPredictionRequest request, final AsyncHandler<CreateBatchPredictionRequest, CreateBatchPredictionResult> asyncHandler) {
        final CreateBatchPredictionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBatchPredictionResult>(){

            @Override
            public CreateBatchPredictionResult call() throws Exception {
                CreateBatchPredictionResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeCreateBatchPrediction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromRDSResult> createDataSourceFromRDSAsync(CreateDataSourceFromRDSRequest request) {
        return this.createDataSourceFromRDSAsync(request, null);
    }

    @Override
    public Future<CreateDataSourceFromRDSResult> createDataSourceFromRDSAsync(CreateDataSourceFromRDSRequest request, final AsyncHandler<CreateDataSourceFromRDSRequest, CreateDataSourceFromRDSResult> asyncHandler) {
        final CreateDataSourceFromRDSRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataSourceFromRDSResult>(){

            @Override
            public CreateDataSourceFromRDSResult call() throws Exception {
                CreateDataSourceFromRDSResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeCreateDataSourceFromRDS(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromRedshiftResult> createDataSourceFromRedshiftAsync(CreateDataSourceFromRedshiftRequest request) {
        return this.createDataSourceFromRedshiftAsync(request, null);
    }

    @Override
    public Future<CreateDataSourceFromRedshiftResult> createDataSourceFromRedshiftAsync(CreateDataSourceFromRedshiftRequest request, final AsyncHandler<CreateDataSourceFromRedshiftRequest, CreateDataSourceFromRedshiftResult> asyncHandler) {
        final CreateDataSourceFromRedshiftRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataSourceFromRedshiftResult>(){

            @Override
            public CreateDataSourceFromRedshiftResult call() throws Exception {
                CreateDataSourceFromRedshiftResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeCreateDataSourceFromRedshift(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromS3Result> createDataSourceFromS3Async(CreateDataSourceFromS3Request request) {
        return this.createDataSourceFromS3Async(request, null);
    }

    @Override
    public Future<CreateDataSourceFromS3Result> createDataSourceFromS3Async(CreateDataSourceFromS3Request request, final AsyncHandler<CreateDataSourceFromS3Request, CreateDataSourceFromS3Result> asyncHandler) {
        final CreateDataSourceFromS3Request finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataSourceFromS3Result>(){

            @Override
            public CreateDataSourceFromS3Result call() throws Exception {
                CreateDataSourceFromS3Result result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeCreateDataSourceFromS3(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEvaluationResult> createEvaluationAsync(CreateEvaluationRequest request) {
        return this.createEvaluationAsync(request, null);
    }

    @Override
    public Future<CreateEvaluationResult> createEvaluationAsync(CreateEvaluationRequest request, final AsyncHandler<CreateEvaluationRequest, CreateEvaluationResult> asyncHandler) {
        final CreateEvaluationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEvaluationResult>(){

            @Override
            public CreateEvaluationResult call() throws Exception {
                CreateEvaluationResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeCreateEvaluation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMLModelResult> createMLModelAsync(CreateMLModelRequest request) {
        return this.createMLModelAsync(request, null);
    }

    @Override
    public Future<CreateMLModelResult> createMLModelAsync(CreateMLModelRequest request, final AsyncHandler<CreateMLModelRequest, CreateMLModelResult> asyncHandler) {
        final CreateMLModelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMLModelResult>(){

            @Override
            public CreateMLModelResult call() throws Exception {
                CreateMLModelResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeCreateMLModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRealtimeEndpointResult> createRealtimeEndpointAsync(CreateRealtimeEndpointRequest request) {
        return this.createRealtimeEndpointAsync(request, null);
    }

    @Override
    public Future<CreateRealtimeEndpointResult> createRealtimeEndpointAsync(CreateRealtimeEndpointRequest request, final AsyncHandler<CreateRealtimeEndpointRequest, CreateRealtimeEndpointResult> asyncHandler) {
        final CreateRealtimeEndpointRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRealtimeEndpointResult>(){

            @Override
            public CreateRealtimeEndpointResult call() throws Exception {
                CreateRealtimeEndpointResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeCreateRealtimeEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBatchPredictionResult> deleteBatchPredictionAsync(DeleteBatchPredictionRequest request) {
        return this.deleteBatchPredictionAsync(request, null);
    }

    @Override
    public Future<DeleteBatchPredictionResult> deleteBatchPredictionAsync(DeleteBatchPredictionRequest request, final AsyncHandler<DeleteBatchPredictionRequest, DeleteBatchPredictionResult> asyncHandler) {
        final DeleteBatchPredictionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBatchPredictionResult>(){

            @Override
            public DeleteBatchPredictionResult call() throws Exception {
                DeleteBatchPredictionResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDeleteBatchPrediction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request) {
        return this.deleteDataSourceAsync(request, null);
    }

    @Override
    public Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request, final AsyncHandler<DeleteDataSourceRequest, DeleteDataSourceResult> asyncHandler) {
        final DeleteDataSourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDataSourceResult>(){

            @Override
            public DeleteDataSourceResult call() throws Exception {
                DeleteDataSourceResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDeleteDataSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEvaluationResult> deleteEvaluationAsync(DeleteEvaluationRequest request) {
        return this.deleteEvaluationAsync(request, null);
    }

    @Override
    public Future<DeleteEvaluationResult> deleteEvaluationAsync(DeleteEvaluationRequest request, final AsyncHandler<DeleteEvaluationRequest, DeleteEvaluationResult> asyncHandler) {
        final DeleteEvaluationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEvaluationResult>(){

            @Override
            public DeleteEvaluationResult call() throws Exception {
                DeleteEvaluationResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDeleteEvaluation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMLModelResult> deleteMLModelAsync(DeleteMLModelRequest request) {
        return this.deleteMLModelAsync(request, null);
    }

    @Override
    public Future<DeleteMLModelResult> deleteMLModelAsync(DeleteMLModelRequest request, final AsyncHandler<DeleteMLModelRequest, DeleteMLModelResult> asyncHandler) {
        final DeleteMLModelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMLModelResult>(){

            @Override
            public DeleteMLModelResult call() throws Exception {
                DeleteMLModelResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDeleteMLModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRealtimeEndpointResult> deleteRealtimeEndpointAsync(DeleteRealtimeEndpointRequest request) {
        return this.deleteRealtimeEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteRealtimeEndpointResult> deleteRealtimeEndpointAsync(DeleteRealtimeEndpointRequest request, final AsyncHandler<DeleteRealtimeEndpointRequest, DeleteRealtimeEndpointResult> asyncHandler) {
        final DeleteRealtimeEndpointRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRealtimeEndpointResult>(){

            @Override
            public DeleteRealtimeEndpointResult call() throws Exception {
                DeleteRealtimeEndpointResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDeleteRealtimeEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        final DeleteTagsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDeleteTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync(DescribeBatchPredictionsRequest request) {
        return this.describeBatchPredictionsAsync(request, null);
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync(DescribeBatchPredictionsRequest request, final AsyncHandler<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResult> asyncHandler) {
        final DescribeBatchPredictionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBatchPredictionsResult>(){

            @Override
            public DescribeBatchPredictionsResult call() throws Exception {
                DescribeBatchPredictionsResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDescribeBatchPredictions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync() {
        return this.describeBatchPredictionsAsync(new DescribeBatchPredictionsRequest());
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync(AsyncHandler<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResult> asyncHandler) {
        return this.describeBatchPredictionsAsync(new DescribeBatchPredictionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync(DescribeDataSourcesRequest request) {
        return this.describeDataSourcesAsync(request, null);
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync(DescribeDataSourcesRequest request, final AsyncHandler<DescribeDataSourcesRequest, DescribeDataSourcesResult> asyncHandler) {
        final DescribeDataSourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDataSourcesResult>(){

            @Override
            public DescribeDataSourcesResult call() throws Exception {
                DescribeDataSourcesResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDescribeDataSources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync() {
        return this.describeDataSourcesAsync(new DescribeDataSourcesRequest());
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync(AsyncHandler<DescribeDataSourcesRequest, DescribeDataSourcesResult> asyncHandler) {
        return this.describeDataSourcesAsync(new DescribeDataSourcesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync(DescribeEvaluationsRequest request) {
        return this.describeEvaluationsAsync(request, null);
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync(DescribeEvaluationsRequest request, final AsyncHandler<DescribeEvaluationsRequest, DescribeEvaluationsResult> asyncHandler) {
        final DescribeEvaluationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEvaluationsResult>(){

            @Override
            public DescribeEvaluationsResult call() throws Exception {
                DescribeEvaluationsResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDescribeEvaluations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync() {
        return this.describeEvaluationsAsync(new DescribeEvaluationsRequest());
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync(AsyncHandler<DescribeEvaluationsRequest, DescribeEvaluationsResult> asyncHandler) {
        return this.describeEvaluationsAsync(new DescribeEvaluationsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync(DescribeMLModelsRequest request) {
        return this.describeMLModelsAsync(request, null);
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync(DescribeMLModelsRequest request, final AsyncHandler<DescribeMLModelsRequest, DescribeMLModelsResult> asyncHandler) {
        final DescribeMLModelsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMLModelsResult>(){

            @Override
            public DescribeMLModelsResult call() throws Exception {
                DescribeMLModelsResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDescribeMLModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync() {
        return this.describeMLModelsAsync(new DescribeMLModelsRequest());
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync(AsyncHandler<DescribeMLModelsRequest, DescribeMLModelsResult> asyncHandler) {
        return this.describeMLModelsAsync(new DescribeMLModelsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        final DescribeTagsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeDescribeTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBatchPredictionResult> getBatchPredictionAsync(GetBatchPredictionRequest request) {
        return this.getBatchPredictionAsync(request, null);
    }

    @Override
    public Future<GetBatchPredictionResult> getBatchPredictionAsync(GetBatchPredictionRequest request, final AsyncHandler<GetBatchPredictionRequest, GetBatchPredictionResult> asyncHandler) {
        final GetBatchPredictionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBatchPredictionResult>(){

            @Override
            public GetBatchPredictionResult call() throws Exception {
                GetBatchPredictionResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeGetBatchPrediction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request) {
        return this.getDataSourceAsync(request, null);
    }

    @Override
    public Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request, final AsyncHandler<GetDataSourceRequest, GetDataSourceResult> asyncHandler) {
        final GetDataSourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataSourceResult>(){

            @Override
            public GetDataSourceResult call() throws Exception {
                GetDataSourceResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeGetDataSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEvaluationResult> getEvaluationAsync(GetEvaluationRequest request) {
        return this.getEvaluationAsync(request, null);
    }

    @Override
    public Future<GetEvaluationResult> getEvaluationAsync(GetEvaluationRequest request, final AsyncHandler<GetEvaluationRequest, GetEvaluationResult> asyncHandler) {
        final GetEvaluationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEvaluationResult>(){

            @Override
            public GetEvaluationResult call() throws Exception {
                GetEvaluationResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeGetEvaluation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMLModelResult> getMLModelAsync(GetMLModelRequest request) {
        return this.getMLModelAsync(request, null);
    }

    @Override
    public Future<GetMLModelResult> getMLModelAsync(GetMLModelRequest request, final AsyncHandler<GetMLModelRequest, GetMLModelResult> asyncHandler) {
        final GetMLModelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMLModelResult>(){

            @Override
            public GetMLModelResult call() throws Exception {
                GetMLModelResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeGetMLModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PredictResult> predictAsync(PredictRequest request) {
        return this.predictAsync(request, null);
    }

    @Override
    public Future<PredictResult> predictAsync(PredictRequest request, final AsyncHandler<PredictRequest, PredictResult> asyncHandler) {
        final PredictRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PredictResult>(){

            @Override
            public PredictResult call() throws Exception {
                PredictResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executePredict(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBatchPredictionResult> updateBatchPredictionAsync(UpdateBatchPredictionRequest request) {
        return this.updateBatchPredictionAsync(request, null);
    }

    @Override
    public Future<UpdateBatchPredictionResult> updateBatchPredictionAsync(UpdateBatchPredictionRequest request, final AsyncHandler<UpdateBatchPredictionRequest, UpdateBatchPredictionResult> asyncHandler) {
        final UpdateBatchPredictionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBatchPredictionResult>(){

            @Override
            public UpdateBatchPredictionResult call() throws Exception {
                UpdateBatchPredictionResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeUpdateBatchPrediction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request) {
        return this.updateDataSourceAsync(request, null);
    }

    @Override
    public Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request, final AsyncHandler<UpdateDataSourceRequest, UpdateDataSourceResult> asyncHandler) {
        final UpdateDataSourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDataSourceResult>(){

            @Override
            public UpdateDataSourceResult call() throws Exception {
                UpdateDataSourceResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeUpdateDataSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEvaluationResult> updateEvaluationAsync(UpdateEvaluationRequest request) {
        return this.updateEvaluationAsync(request, null);
    }

    @Override
    public Future<UpdateEvaluationResult> updateEvaluationAsync(UpdateEvaluationRequest request, final AsyncHandler<UpdateEvaluationRequest, UpdateEvaluationResult> asyncHandler) {
        final UpdateEvaluationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEvaluationResult>(){

            @Override
            public UpdateEvaluationResult call() throws Exception {
                UpdateEvaluationResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeUpdateEvaluation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMLModelResult> updateMLModelAsync(UpdateMLModelRequest request) {
        return this.updateMLModelAsync(request, null);
    }

    @Override
    public Future<UpdateMLModelResult> updateMLModelAsync(UpdateMLModelRequest request, final AsyncHandler<UpdateMLModelRequest, UpdateMLModelResult> asyncHandler) {
        final UpdateMLModelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMLModelResult>(){

            @Override
            public UpdateMLModelResult call() throws Exception {
                UpdateMLModelResult result = null;
                try {
                    result = AmazonMachineLearningAsyncClient.this.executeUpdateMLModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

