/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTimeToLiveResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ListTagsOfResourceRequest;
import com.amazonaws.services.dynamodbv2.model.ListTagsOfResourceResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TagResourceRequest;
import com.amazonaws.services.dynamodbv2.model.TagResourceResult;
import com.amazonaws.services.dynamodbv2.model.UntagResourceRequest;
import com.amazonaws.services.dynamodbv2.model.UntagResourceResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDynamoDBAsyncClient
extends AmazonDynamoDBClient
implements AmazonDynamoDBAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonDynamoDBAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonDynamoDBAsyncClientBuilder asyncBuilder() {
        return AmazonDynamoDBAsyncClientBuilder.standard();
    }

    AmazonDynamoDBAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(BatchGetItemRequest request) {
        return this.batchGetItemAsync(request, null);
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(BatchGetItemRequest request, final AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        final BatchGetItemRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call() throws Exception {
                BatchGetItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeBatchGetItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems).withReturnConsumedCapacity(returnConsumedCapacity));
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems).withReturnConsumedCapacity(returnConsumedCapacity), asyncHandler);
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems));
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems), asyncHandler);
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(BatchWriteItemRequest request) {
        return this.batchWriteItemAsync(request, null);
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(BatchWriteItemRequest request, final AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) {
        final BatchWriteItemRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call() throws Exception {
                BatchWriteItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeBatchWriteItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(Map<String, List<WriteRequest>> requestItems) {
        return this.batchWriteItemAsync(new BatchWriteItemRequest().withRequestItems(requestItems));
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(Map<String, List<WriteRequest>> requestItems, AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) {
        return this.batchWriteItemAsync(new BatchWriteItemRequest().withRequestItems(requestItems), asyncHandler);
    }

    @Override
    public Future<CreateTableResult> createTableAsync(CreateTableRequest request) {
        return this.createTableAsync(request, null);
    }

    @Override
    public Future<CreateTableResult> createTableAsync(CreateTableRequest request, final AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        final CreateTableRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                CreateTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeCreateTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) {
        return this.createTableAsync(new CreateTableRequest().withAttributeDefinitions(attributeDefinitions).withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(provisionedThroughput));
    }

    @Override
    public Future<CreateTableResult> createTableAsync(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput, AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        return this.createTableAsync(new CreateTableRequest().withAttributeDefinitions(attributeDefinitions).withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(provisionedThroughput), asyncHandler);
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(DeleteItemRequest request) {
        return this.deleteItemAsync(request, null);
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(DeleteItemRequest request, final AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        final DeleteItemRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteItemResult>(){

            @Override
            public DeleteItemResult call() throws Exception {
                DeleteItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDeleteItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key));
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key), asyncHandler);
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, String returnValues) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues));
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, String returnValues, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request) {
        return this.deleteTableAsync(request, null);
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request, final AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        final DeleteTableRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                DeleteTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDeleteTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(String tableName) {
        return this.deleteTableAsync(new DeleteTableRequest().withTableName(tableName));
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(String tableName, AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        return this.deleteTableAsync(new DeleteTableRequest().withTableName(tableName), asyncHandler);
    }

    @Override
    public Future<DescribeLimitsResult> describeLimitsAsync(DescribeLimitsRequest request) {
        return this.describeLimitsAsync(request, null);
    }

    @Override
    public Future<DescribeLimitsResult> describeLimitsAsync(DescribeLimitsRequest request, final AsyncHandler<DescribeLimitsRequest, DescribeLimitsResult> asyncHandler) {
        final DescribeLimitsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLimitsResult>(){

            @Override
            public DescribeLimitsResult call() throws Exception {
                DescribeLimitsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeLimits(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request) {
        return this.describeTableAsync(request, null);
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request, final AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        final DescribeTableRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                DescribeTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(String tableName) {
        return this.describeTableAsync(new DescribeTableRequest().withTableName(tableName));
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(String tableName, AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        return this.describeTableAsync(new DescribeTableRequest().withTableName(tableName), asyncHandler);
    }

    @Override
    public Future<DescribeTimeToLiveResult> describeTimeToLiveAsync(DescribeTimeToLiveRequest request) {
        return this.describeTimeToLiveAsync(request, null);
    }

    @Override
    public Future<DescribeTimeToLiveResult> describeTimeToLiveAsync(DescribeTimeToLiveRequest request, final AsyncHandler<DescribeTimeToLiveRequest, DescribeTimeToLiveResult> asyncHandler) {
        final DescribeTimeToLiveRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTimeToLiveResult>(){

            @Override
            public DescribeTimeToLiveResult call() throws Exception {
                DescribeTimeToLiveResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeTimeToLive(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(GetItemRequest request) {
        return this.getItemAsync(request, null);
    }

    @Override
    public Future<GetItemResult> getItemAsync(GetItemRequest request, final AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        final GetItemRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetItemResult>(){

            @Override
            public GetItemResult call() throws Exception {
                GetItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeGetItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key));
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key), asyncHandler);
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead));
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, Boolean consistentRead, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request) {
        return this.listTablesAsync(request, null);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        final ListTablesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeListTables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync() {
        return this.listTablesAsync(new ListTablesRequest());
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, Integer limit) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName).withLimit(limit));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, Integer limit, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName).withLimit(limit), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(Integer limit) {
        return this.listTablesAsync(new ListTablesRequest().withLimit(limit));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(Integer limit, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withLimit(limit), asyncHandler);
    }

    @Override
    public Future<ListTagsOfResourceResult> listTagsOfResourceAsync(ListTagsOfResourceRequest request) {
        return this.listTagsOfResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsOfResourceResult> listTagsOfResourceAsync(ListTagsOfResourceRequest request, final AsyncHandler<ListTagsOfResourceRequest, ListTagsOfResourceResult> asyncHandler) {
        final ListTagsOfResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsOfResourceResult>(){

            @Override
            public ListTagsOfResourceResult call() throws Exception {
                ListTagsOfResourceResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeListTagsOfResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(PutItemRequest request) {
        return this.putItemAsync(request, null);
    }

    @Override
    public Future<PutItemResult> putItemAsync(PutItemRequest request, final AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        final PutItemRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutItemResult>(){

            @Override
            public PutItemResult call() throws Exception {
                PutItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executePutItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item));
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item), asyncHandler);
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, String returnValues) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues));
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, String returnValues, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<QueryResult> queryAsync(QueryRequest request) {
        return this.queryAsync(request, null);
    }

    @Override
    public Future<QueryResult> queryAsync(QueryRequest request, final AsyncHandler<QueryRequest, QueryResult> asyncHandler) {
        final QueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                QueryResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(ScanRequest request) {
        return this.scanAsync(request, null);
    }

    @Override
    public Future<ScanResult> scanAsync(ScanRequest request, final AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        final ScanRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() throws Exception {
                ScanResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeScan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet), asyncHandler);
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, Map<String, Condition> scanFilter) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withScanFilter(scanFilter));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, Map<String, Condition> scanFilter, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withScanFilter(scanFilter), asyncHandler);
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet).withScanFilter(scanFilter));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet).withScanFilter(scanFilter), asyncHandler);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(UpdateItemRequest request) {
        return this.updateItemAsync(request, null);
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(UpdateItemRequest request, final AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        final UpdateItemRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateItemResult>(){

            @Override
            public UpdateItemResult call() throws Exception {
                UpdateItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates));
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates), asyncHandler);
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues));
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request) {
        return this.updateTableAsync(request, null);
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request, final AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        final UpdateTableRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                UpdateTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(String tableName, ProvisionedThroughput provisionedThroughput) {
        return this.updateTableAsync(new UpdateTableRequest().withTableName(tableName).withProvisionedThroughput(provisionedThroughput));
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(String tableName, ProvisionedThroughput provisionedThroughput, AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        return this.updateTableAsync(new UpdateTableRequest().withTableName(tableName).withProvisionedThroughput(provisionedThroughput), asyncHandler);
    }

    @Override
    public Future<UpdateTimeToLiveResult> updateTimeToLiveAsync(UpdateTimeToLiveRequest request) {
        return this.updateTimeToLiveAsync(request, null);
    }

    @Override
    public Future<UpdateTimeToLiveResult> updateTimeToLiveAsync(UpdateTimeToLiveRequest request, final AsyncHandler<UpdateTimeToLiveRequest, UpdateTimeToLiveResult> asyncHandler) {
        final UpdateTimeToLiveRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTimeToLiveResult>(){

            @Override
            public UpdateTimeToLiveResult call() throws Exception {
                UpdateTimeToLiveResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateTimeToLive(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

