/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementAsync;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClient;
import com.amazonaws.services.simplesystemsmanagement.model.AddTagsToResourceRequest;
import com.amazonaws.services.simplesystemsmanagement.model.AddTagsToResourceResult;
import com.amazonaws.services.simplesystemsmanagement.model.CancelCommandRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CancelCommandResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateActivationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateActivationResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteActivationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteActivationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeregisterManagedInstanceRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeregisterManagedInstanceResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeActivationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeActivationsResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentPermissionRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentPermissionResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeInstanceInformationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeInstanceInformationResult;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandInvocationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandInvocationsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListTagsForResourceRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListTagsForResourceResult;
import com.amazonaws.services.simplesystemsmanagement.model.ModifyDocumentPermissionRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ModifyDocumentPermissionResult;
import com.amazonaws.services.simplesystemsmanagement.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.simplesystemsmanagement.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.simplesystemsmanagement.model.SendCommandRequest;
import com.amazonaws.services.simplesystemsmanagement.model.SendCommandResult;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusRequest;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusResult;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateManagedInstanceRoleRequest;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateManagedInstanceRoleResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSimpleSystemsManagementAsyncClient
extends AWSSimpleSystemsManagementClient
implements AWSSimpleSystemsManagementAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSSimpleSystemsManagementAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSSimpleSystemsManagementAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request) {
        return this.addTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(final AddTagsToResourceRequest request, final AsyncHandler<AddTagsToResourceRequest, AddTagsToResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                AddTagsToResourceResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.addTagsToResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelCommandResult> cancelCommandAsync(CancelCommandRequest request) {
        return this.cancelCommandAsync(request, null);
    }

    @Override
    public Future<CancelCommandResult> cancelCommandAsync(final CancelCommandRequest request, final AsyncHandler<CancelCommandRequest, CancelCommandResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelCommandResult>(){

            @Override
            public CancelCommandResult call() throws Exception {
                CancelCommandResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.cancelCommand(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateActivationResult> createActivationAsync(CreateActivationRequest request) {
        return this.createActivationAsync(request, null);
    }

    @Override
    public Future<CreateActivationResult> createActivationAsync(final CreateActivationRequest request, final AsyncHandler<CreateActivationRequest, CreateActivationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateActivationResult>(){

            @Override
            public CreateActivationResult call() throws Exception {
                CreateActivationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.createActivation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAssociationResult> createAssociationAsync(CreateAssociationRequest request) {
        return this.createAssociationAsync(request, null);
    }

    @Override
    public Future<CreateAssociationResult> createAssociationAsync(final CreateAssociationRequest request, final AsyncHandler<CreateAssociationRequest, CreateAssociationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAssociationResult>(){

            @Override
            public CreateAssociationResult call() throws Exception {
                CreateAssociationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.createAssociation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAssociationBatchResult> createAssociationBatchAsync(CreateAssociationBatchRequest request) {
        return this.createAssociationBatchAsync(request, null);
    }

    @Override
    public Future<CreateAssociationBatchResult> createAssociationBatchAsync(final CreateAssociationBatchRequest request, final AsyncHandler<CreateAssociationBatchRequest, CreateAssociationBatchResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAssociationBatchResult>(){

            @Override
            public CreateAssociationBatchResult call() throws Exception {
                CreateAssociationBatchResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.createAssociationBatch(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDocumentResult> createDocumentAsync(CreateDocumentRequest request) {
        return this.createDocumentAsync(request, null);
    }

    @Override
    public Future<CreateDocumentResult> createDocumentAsync(final CreateDocumentRequest request, final AsyncHandler<CreateDocumentRequest, CreateDocumentResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDocumentResult>(){

            @Override
            public CreateDocumentResult call() throws Exception {
                CreateDocumentResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.createDocument(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteActivationResult> deleteActivationAsync(DeleteActivationRequest request) {
        return this.deleteActivationAsync(request, null);
    }

    @Override
    public Future<DeleteActivationResult> deleteActivationAsync(final DeleteActivationRequest request, final AsyncHandler<DeleteActivationRequest, DeleteActivationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteActivationResult>(){

            @Override
            public DeleteActivationResult call() throws Exception {
                DeleteActivationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.deleteActivation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAssociationResult> deleteAssociationAsync(DeleteAssociationRequest request) {
        return this.deleteAssociationAsync(request, null);
    }

    @Override
    public Future<DeleteAssociationResult> deleteAssociationAsync(final DeleteAssociationRequest request, final AsyncHandler<DeleteAssociationRequest, DeleteAssociationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAssociationResult>(){

            @Override
            public DeleteAssociationResult call() throws Exception {
                DeleteAssociationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.deleteAssociation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDocumentResult> deleteDocumentAsync(DeleteDocumentRequest request) {
        return this.deleteDocumentAsync(request, null);
    }

    @Override
    public Future<DeleteDocumentResult> deleteDocumentAsync(final DeleteDocumentRequest request, final AsyncHandler<DeleteDocumentRequest, DeleteDocumentResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDocumentResult>(){

            @Override
            public DeleteDocumentResult call() throws Exception {
                DeleteDocumentResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.deleteDocument(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterManagedInstanceResult> deregisterManagedInstanceAsync(DeregisterManagedInstanceRequest request) {
        return this.deregisterManagedInstanceAsync(request, null);
    }

    @Override
    public Future<DeregisterManagedInstanceResult> deregisterManagedInstanceAsync(final DeregisterManagedInstanceRequest request, final AsyncHandler<DeregisterManagedInstanceRequest, DeregisterManagedInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeregisterManagedInstanceResult>(){

            @Override
            public DeregisterManagedInstanceResult call() throws Exception {
                DeregisterManagedInstanceResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.deregisterManagedInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeActivationsResult> describeActivationsAsync(DescribeActivationsRequest request) {
        return this.describeActivationsAsync(request, null);
    }

    @Override
    public Future<DescribeActivationsResult> describeActivationsAsync(final DescribeActivationsRequest request, final AsyncHandler<DescribeActivationsRequest, DescribeActivationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeActivationsResult>(){

            @Override
            public DescribeActivationsResult call() throws Exception {
                DescribeActivationsResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.describeActivations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAssociationResult> describeAssociationAsync(DescribeAssociationRequest request) {
        return this.describeAssociationAsync(request, null);
    }

    @Override
    public Future<DescribeAssociationResult> describeAssociationAsync(final DescribeAssociationRequest request, final AsyncHandler<DescribeAssociationRequest, DescribeAssociationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAssociationResult>(){

            @Override
            public DescribeAssociationResult call() throws Exception {
                DescribeAssociationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.describeAssociation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDocumentResult> describeDocumentAsync(DescribeDocumentRequest request) {
        return this.describeDocumentAsync(request, null);
    }

    @Override
    public Future<DescribeDocumentResult> describeDocumentAsync(final DescribeDocumentRequest request, final AsyncHandler<DescribeDocumentRequest, DescribeDocumentResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDocumentResult>(){

            @Override
            public DescribeDocumentResult call() throws Exception {
                DescribeDocumentResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.describeDocument(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDocumentPermissionResult> describeDocumentPermissionAsync(DescribeDocumentPermissionRequest request) {
        return this.describeDocumentPermissionAsync(request, null);
    }

    @Override
    public Future<DescribeDocumentPermissionResult> describeDocumentPermissionAsync(final DescribeDocumentPermissionRequest request, final AsyncHandler<DescribeDocumentPermissionRequest, DescribeDocumentPermissionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDocumentPermissionResult>(){

            @Override
            public DescribeDocumentPermissionResult call() throws Exception {
                DescribeDocumentPermissionResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.describeDocumentPermission(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInstanceInformationResult> describeInstanceInformationAsync(DescribeInstanceInformationRequest request) {
        return this.describeInstanceInformationAsync(request, null);
    }

    @Override
    public Future<DescribeInstanceInformationResult> describeInstanceInformationAsync(final DescribeInstanceInformationRequest request, final AsyncHandler<DescribeInstanceInformationRequest, DescribeInstanceInformationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeInstanceInformationResult>(){

            @Override
            public DescribeInstanceInformationResult call() throws Exception {
                DescribeInstanceInformationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.describeInstanceInformation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentResult> getDocumentAsync(GetDocumentRequest request) {
        return this.getDocumentAsync(request, null);
    }

    @Override
    public Future<GetDocumentResult> getDocumentAsync(final GetDocumentRequest request, final AsyncHandler<GetDocumentRequest, GetDocumentResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDocumentResult>(){

            @Override
            public GetDocumentResult call() throws Exception {
                GetDocumentResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.getDocument(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociationsResult> listAssociationsAsync(ListAssociationsRequest request) {
        return this.listAssociationsAsync(request, null);
    }

    @Override
    public Future<ListAssociationsResult> listAssociationsAsync(final ListAssociationsRequest request, final AsyncHandler<ListAssociationsRequest, ListAssociationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAssociationsResult>(){

            @Override
            public ListAssociationsResult call() throws Exception {
                ListAssociationsResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.listAssociations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCommandInvocationsResult> listCommandInvocationsAsync(ListCommandInvocationsRequest request) {
        return this.listCommandInvocationsAsync(request, null);
    }

    @Override
    public Future<ListCommandInvocationsResult> listCommandInvocationsAsync(final ListCommandInvocationsRequest request, final AsyncHandler<ListCommandInvocationsRequest, ListCommandInvocationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCommandInvocationsResult>(){

            @Override
            public ListCommandInvocationsResult call() throws Exception {
                ListCommandInvocationsResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.listCommandInvocations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCommandsResult> listCommandsAsync(ListCommandsRequest request) {
        return this.listCommandsAsync(request, null);
    }

    @Override
    public Future<ListCommandsResult> listCommandsAsync(final ListCommandsRequest request, final AsyncHandler<ListCommandsRequest, ListCommandsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCommandsResult>(){

            @Override
            public ListCommandsResult call() throws Exception {
                ListCommandsResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.listCommands(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDocumentsResult> listDocumentsAsync(ListDocumentsRequest request) {
        return this.listDocumentsAsync(request, null);
    }

    @Override
    public Future<ListDocumentsResult> listDocumentsAsync(final ListDocumentsRequest request, final AsyncHandler<ListDocumentsRequest, ListDocumentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDocumentsResult>(){

            @Override
            public ListDocumentsResult call() throws Exception {
                ListDocumentsResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.listDocuments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDocumentsResult> listDocumentsAsync() {
        return this.listDocumentsAsync(new ListDocumentsRequest());
    }

    @Override
    public Future<ListDocumentsResult> listDocumentsAsync(AsyncHandler<ListDocumentsRequest, ListDocumentsResult> asyncHandler) {
        return this.listDocumentsAsync(new ListDocumentsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.listTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyDocumentPermissionResult> modifyDocumentPermissionAsync(ModifyDocumentPermissionRequest request) {
        return this.modifyDocumentPermissionAsync(request, null);
    }

    @Override
    public Future<ModifyDocumentPermissionResult> modifyDocumentPermissionAsync(final ModifyDocumentPermissionRequest request, final AsyncHandler<ModifyDocumentPermissionRequest, ModifyDocumentPermissionResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyDocumentPermissionResult>(){

            @Override
            public ModifyDocumentPermissionResult call() throws Exception {
                ModifyDocumentPermissionResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.modifyDocumentPermission(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request) {
        return this.removeTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(final RemoveTagsFromResourceRequest request, final AsyncHandler<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                RemoveTagsFromResourceResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.removeTagsFromResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendCommandResult> sendCommandAsync(SendCommandRequest request) {
        return this.sendCommandAsync(request, null);
    }

    @Override
    public Future<SendCommandResult> sendCommandAsync(final SendCommandRequest request, final AsyncHandler<SendCommandRequest, SendCommandResult> asyncHandler) {
        return this.executorService.submit(new Callable<SendCommandResult>(){

            @Override
            public SendCommandResult call() throws Exception {
                SendCommandResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.sendCommand(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAssociationStatusResult> updateAssociationStatusAsync(UpdateAssociationStatusRequest request) {
        return this.updateAssociationStatusAsync(request, null);
    }

    @Override
    public Future<UpdateAssociationStatusResult> updateAssociationStatusAsync(final UpdateAssociationStatusRequest request, final AsyncHandler<UpdateAssociationStatusRequest, UpdateAssociationStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateAssociationStatusResult>(){

            @Override
            public UpdateAssociationStatusResult call() throws Exception {
                UpdateAssociationStatusResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.updateAssociationStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateManagedInstanceRoleResult> updateManagedInstanceRoleAsync(UpdateManagedInstanceRoleRequest request) {
        return this.updateManagedInstanceRoleAsync(request, null);
    }

    @Override
    public Future<UpdateManagedInstanceRoleResult> updateManagedInstanceRoleAsync(final UpdateManagedInstanceRoleRequest request, final AsyncHandler<UpdateManagedInstanceRoleRequest, UpdateManagedInstanceRoleResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateManagedInstanceRoleResult>(){

            @Override
            public UpdateManagedInstanceRoleResult call() throws Exception {
                UpdateManagedInstanceRoleResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.updateManagedInstanceRole(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

