/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.RetireGrantRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RetireGrantRequestMarshaller
implements Marshaller<Request<RetireGrantRequest>, RetireGrantRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RetireGrantRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RetireGrantRequest> marshall(RetireGrantRequest retireGrantRequest) {
        if (retireGrantRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RetireGrantRequest> request = new DefaultRequest<RetireGrantRequest>(retireGrantRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.RetireGrant");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (retireGrantRequest.getGrantToken() != null) {
                jsonGenerator.writeFieldName("GrantToken").writeValue(retireGrantRequest.getGrantToken());
            }
            if (retireGrantRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(retireGrantRequest.getKeyId());
            }
            if (retireGrantRequest.getGrantId() != null) {
                jsonGenerator.writeFieldName("GrantId").writeValue(retireGrantRequest.getGrantId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

