/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.UpdateAliasRequest;
import com.amazonaws.services.gamelift.model.transform.RoutingStrategyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateAliasRequestMarshaller
implements Marshaller<Request<UpdateAliasRequest>, UpdateAliasRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateAliasRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateAliasRequest> marshall(UpdateAliasRequest updateAliasRequest) {
        if (updateAliasRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateAliasRequest> request = new DefaultRequest<UpdateAliasRequest>(updateAliasRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateAlias");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateAliasRequest.getAliasId() != null) {
                jsonGenerator.writeFieldName("AliasId").writeValue(updateAliasRequest.getAliasId());
            }
            if (updateAliasRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateAliasRequest.getName());
            }
            if (updateAliasRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateAliasRequest.getDescription());
            }
            if (updateAliasRequest.getRoutingStrategy() != null) {
                jsonGenerator.writeFieldName("RoutingStrategy");
                RoutingStrategyJsonMarshaller.getInstance().marshall(updateAliasRequest.getRoutingStrategy(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

