/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import com.amazonaws.services.ec2.model.ImportInstanceRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.UserData;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ImportInstanceRequestMarshaller
implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {
    @Override
    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {
        SdkInternalList diskImagesList;
        ImportInstanceLaunchSpecification launchSpecification;
        if (importInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportInstanceRequest> request = new DefaultRequest<ImportInstanceRequest>(importInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (importInstanceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(importInstanceRequest.getDescription()));
        }
        if ((launchSpecification = importInstanceRequest.getLaunchSpecification()) != null) {
            Placement placement;
            UserData userData;
            SdkInternalList groupIdsList;
            SdkInternalList groupNamesList;
            if (launchSpecification.getArchitecture() != null) {
                request.addParameter("LaunchSpecification.Architecture", StringUtils.fromString(launchSpecification.getArchitecture()));
            }
            if (!(groupNamesList = (SdkInternalList)launchSpecification.getGroupNames()).isEmpty() || !groupNamesList.isAutoConstruct()) {
                int groupNamesListIndex = 1;
                for (Object groupNamesListValue : groupNamesList) {
                    if (groupNamesListValue != null) {
                        request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex, StringUtils.fromString((String)groupNamesListValue));
                    }
                    ++groupNamesListIndex;
                }
            }
            if (!(groupIdsList = (SdkInternalList)launchSpecification.getGroupIds()).isEmpty() || !groupIdsList.isAutoConstruct()) {
                int groupIdsListIndex = 1;
                for (String groupIdsListValue : groupIdsList) {
                    if (groupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex, StringUtils.fromString(groupIdsListValue));
                    }
                    ++groupIdsListIndex;
                }
            }
            if (launchSpecification.getAdditionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo", StringUtils.fromString(launchSpecification.getAdditionalInfo()));
            }
            if ((userData = launchSpecification.getUserData()) != null && userData.getData() != null) {
                request.addParameter("LaunchSpecification.UserData.Data", StringUtils.fromString(userData.getData()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString(launchSpecification.getInstanceType()));
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
                }
                if (placement.getTenancy() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString(placement.getTenancy()));
                }
                if (placement.getHostId() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostId", StringUtils.fromString(placement.getHostId()));
                }
                if (placement.getAffinity() != null) {
                    request.addParameter("LaunchSpecification.Placement.Affinity", StringUtils.fromString(placement.getAffinity()));
                }
            }
            if (launchSpecification.getMonitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean(launchSpecification.getMonitoring()));
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString(launchSpecification.getSubnetId()));
            }
            if (launchSpecification.getInstanceInitiatedShutdownBehavior() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior", StringUtils.fromString(launchSpecification.getInstanceInitiatedShutdownBehavior()));
            }
            if (launchSpecification.getPrivateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress", StringUtils.fromString(launchSpecification.getPrivateIpAddress()));
            }
        }
        if (!(diskImagesList = (SdkInternalList)importInstanceRequest.getDiskImages()).isEmpty() || !diskImagesList.isAutoConstruct()) {
            int diskImagesListIndex = 1;
            for (DiskImage diskImagesListValue : diskImagesList) {
                VolumeDetail volume;
                DiskImageDetail image = diskImagesListValue.getImage();
                if (image != null) {
                    if (image.getFormat() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format", StringUtils.fromString(image.getFormat()));
                    }
                    if (image.getBytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes", StringUtils.fromLong(image.getBytes()));
                    }
                    if (image.getImportManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl", StringUtils.fromString(image.getImportManifestUrl()));
                    }
                }
                if (diskImagesListValue.getDescription() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description", StringUtils.fromString(diskImagesListValue.getDescription()));
                }
                if ((volume = diskImagesListValue.getVolume()) != null && volume.getSize() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size", StringUtils.fromLong(volume.getSize()));
                }
                ++diskImagesListIndex;
            }
        }
        if (importInstanceRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString(importInstanceRequest.getPlatform()));
        }
        return request;
    }
}

