/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.PipelineDescription;
import com.amazonaws.services.datapipeline.model.Tag;
import com.amazonaws.services.datapipeline.model.transform.FieldJsonMarshaller;
import com.amazonaws.services.datapipeline.model.transform.TagJsonMarshaller;

public class PipelineDescriptionJsonMarshaller {
    private static PipelineDescriptionJsonMarshaller instance;

    public void marshall(PipelineDescription pipelineDescription, StructuredJsonGenerator jsonGenerator) {
        if (pipelineDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList tagsList;
            SdkInternalList fieldsList;
            jsonGenerator.writeStartObject();
            if (pipelineDescription.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(pipelineDescription.getPipelineId());
            }
            if (pipelineDescription.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(pipelineDescription.getName());
            }
            if (!(fieldsList = (SdkInternalList)pipelineDescription.getFields()).isEmpty() || !fieldsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("fields");
                jsonGenerator.writeStartArray();
                for (Field fieldsListValue : fieldsList) {
                    if (fieldsListValue == null) continue;
                    FieldJsonMarshaller.getInstance().marshall(fieldsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (pipelineDescription.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(pipelineDescription.getDescription());
            }
            if (!(tagsList = (SdkInternalList)pipelineDescription.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineDescriptionJsonMarshaller();
        }
        return instance;
    }
}

