/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.CreateEndpointRequest;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.amazonaws.services.databasemigrationservice.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateEndpointRequestMarshaller
implements Marshaller<Request<CreateEndpointRequest>, CreateEndpointRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateEndpointRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateEndpointRequest> marshall(CreateEndpointRequest createEndpointRequest) {
        if (createEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateEndpointRequest> request = new DefaultRequest<CreateEndpointRequest>(createEndpointRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.CreateEndpoint");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createEndpointRequest.getEndpointIdentifier() != null) {
                jsonGenerator.writeFieldName("EndpointIdentifier").writeValue(createEndpointRequest.getEndpointIdentifier());
            }
            if (createEndpointRequest.getEndpointType() != null) {
                jsonGenerator.writeFieldName("EndpointType").writeValue(createEndpointRequest.getEndpointType());
            }
            if (createEndpointRequest.getEngineName() != null) {
                jsonGenerator.writeFieldName("EngineName").writeValue(createEndpointRequest.getEngineName());
            }
            if (createEndpointRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(createEndpointRequest.getUsername());
            }
            if (createEndpointRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(createEndpointRequest.getPassword());
            }
            if (createEndpointRequest.getServerName() != null) {
                jsonGenerator.writeFieldName("ServerName").writeValue(createEndpointRequest.getServerName());
            }
            if (createEndpointRequest.getPort() != null) {
                jsonGenerator.writeFieldName("Port").writeValue(createEndpointRequest.getPort());
            }
            if (createEndpointRequest.getDatabaseName() != null) {
                jsonGenerator.writeFieldName("DatabaseName").writeValue(createEndpointRequest.getDatabaseName());
            }
            if (createEndpointRequest.getExtraConnectionAttributes() != null) {
                jsonGenerator.writeFieldName("ExtraConnectionAttributes").writeValue(createEndpointRequest.getExtraConnectionAttributes());
            }
            if (createEndpointRequest.getKmsKeyId() != null) {
                jsonGenerator.writeFieldName("KmsKeyId").writeValue(createEndpointRequest.getKmsKeyId());
            }
            if ((tagsList = createEndpointRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

