/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudsearchdomain.model.SearchRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.io.ByteArrayInputStream;

public class SearchRequestMarshaller
implements Marshaller<Request<SearchRequest>, SearchRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SearchRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SearchRequest> marshall(SearchRequest searchRequest) {
        if (searchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SearchRequest> request = new DefaultRequest<SearchRequest>(searchRequest, "AmazonCloudSearchDomain");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-01-01/search?format=sdk&pretty=true";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (searchRequest.getCursor() != null) {
            request.addParameter("cursor", StringUtils.fromString(searchRequest.getCursor()));
        }
        if (searchRequest.getExpr() != null) {
            request.addParameter("expr", StringUtils.fromString(searchRequest.getExpr()));
        }
        if (searchRequest.getFacet() != null) {
            request.addParameter("facet", StringUtils.fromString(searchRequest.getFacet()));
        }
        if (searchRequest.getFilterQuery() != null) {
            request.addParameter("fq", StringUtils.fromString(searchRequest.getFilterQuery()));
        }
        if (searchRequest.getHighlight() != null) {
            request.addParameter("highlight", StringUtils.fromString(searchRequest.getHighlight()));
        }
        if (searchRequest.getPartial() != null) {
            request.addParameter("partial", StringUtils.fromBoolean(searchRequest.getPartial()));
        }
        if (searchRequest.getQuery() != null) {
            request.addParameter("q", StringUtils.fromString(searchRequest.getQuery()));
        }
        if (searchRequest.getQueryOptions() != null) {
            request.addParameter("q.options", StringUtils.fromString(searchRequest.getQueryOptions()));
        }
        if (searchRequest.getQueryParser() != null) {
            request.addParameter("q.parser", StringUtils.fromString(searchRequest.getQueryParser()));
        }
        if (searchRequest.getReturn() != null) {
            request.addParameter("return", StringUtils.fromString(searchRequest.getReturn()));
        }
        if (searchRequest.getSize() != null) {
            request.addParameter("size", StringUtils.fromLong(searchRequest.getSize()));
        }
        if (searchRequest.getSort() != null) {
            request.addParameter("sort", StringUtils.fromString(searchRequest.getSort()));
        }
        if (searchRequest.getStart() != null) {
            request.addParameter("start", StringUtils.fromLong(searchRequest.getStart()));
        }
        if (searchRequest.getStats() != null) {
            request.addParameter("stats", StringUtils.fromString(searchRequest.getStats()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

