/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.Listener;
import com.amazonaws.services.elasticbeanstalk.model.LoadBalancerDescription;
import com.amazonaws.services.elasticbeanstalk.model.transform.ListenerStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class LoadBalancerDescriptionStaxUnmarshaller
implements Unmarshaller<LoadBalancerDescription, StaxUnmarshallerContext> {
    private static LoadBalancerDescriptionStaxUnmarshaller instance;

    @Override
    public LoadBalancerDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoadBalancerDescription loadBalancerDescription = new LoadBalancerDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return loadBalancerDescription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LoadBalancerName", targetDepth)) {
                    loadBalancerDescription.setLoadBalancerName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Domain", targetDepth)) {
                    loadBalancerDescription.setDomain(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Listeners", targetDepth)) {
                    loadBalancerDescription.withListeners(new ArrayList<Listener>());
                    continue;
                }
                if (!context.testExpression("Listeners/member", targetDepth)) continue;
                loadBalancerDescription.withListeners(ListenerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return loadBalancerDescription;
    }

    public static LoadBalancerDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LoadBalancerDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

