/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeConfigurationOptionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String templateName;
    private String environmentName;
    private String solutionStackName;
    private String platformArn;
    private SdkInternalList<OptionSpecification> options;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public DescribeConfigurationOptionsRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public DescribeConfigurationOptionsRequest withTemplateName(String templateName) {
        this.setTemplateName(templateName);
        return this;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public DescribeConfigurationOptionsRequest withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public DescribeConfigurationOptionsRequest withSolutionStackName(String solutionStackName) {
        this.setSolutionStackName(solutionStackName);
        return this;
    }

    public void setPlatformArn(String platformArn) {
        this.platformArn = platformArn;
    }

    public String getPlatformArn() {
        return this.platformArn;
    }

    public DescribeConfigurationOptionsRequest withPlatformArn(String platformArn) {
        this.setPlatformArn(platformArn);
        return this;
    }

    public List<OptionSpecification> getOptions() {
        if (this.options == null) {
            this.options = new SdkInternalList();
        }
        return this.options;
    }

    public void setOptions(Collection<OptionSpecification> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        this.options = new SdkInternalList<OptionSpecification>(options);
    }

    public DescribeConfigurationOptionsRequest withOptions(OptionSpecification ... options) {
        if (this.options == null) {
            this.setOptions(new SdkInternalList<OptionSpecification>(options.length));
        }
        for (OptionSpecification ele : options) {
            this.options.add(ele);
        }
        return this;
    }

    public DescribeConfigurationOptionsRequest withOptions(Collection<OptionSpecification> options) {
        this.setOptions(options);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: ").append(this.getTemplateName()).append(",");
        }
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.getSolutionStackName()).append(",");
        }
        if (this.getPlatformArn() != null) {
            sb.append("PlatformArn: ").append(this.getPlatformArn()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeConfigurationOptionsRequest other = (DescribeConfigurationOptionsRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getPlatformArn() == null ^ this.getPlatformArn() == null) {
            return false;
        }
        if (other.getPlatformArn() != null && !other.getPlatformArn().equals(this.getPlatformArn())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformArn() == null ? 0 : this.getPlatformArn().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    @Override
    public DescribeConfigurationOptionsRequest clone() {
        return (DescribeConfigurationOptionsRequest)super.clone();
    }
}

