/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.MaxCountRule;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MaxCountRuleStaxUnmarshaller
implements Unmarshaller<MaxCountRule, StaxUnmarshallerContext> {
    private static MaxCountRuleStaxUnmarshaller instance;

    @Override
    public MaxCountRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        MaxCountRule maxCountRule = new MaxCountRule();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return maxCountRule;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    maxCountRule.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxCount", targetDepth)) {
                    maxCountRule.setMaxCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DeleteSourceFromS3", targetDepth)) continue;
                maxCountRule.setDeleteSourceFromS3(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return maxCountRule;
    }

    public static MaxCountRuleStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MaxCountRuleStaxUnmarshaller();
        }
        return instance;
    }
}

