/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.xray.AWSXRayAsync;
import com.amazonaws.services.xray.AWSXRayAsyncClientBuilder;
import com.amazonaws.services.xray.AWSXRayClient;
import com.amazonaws.services.xray.model.BatchGetTracesRequest;
import com.amazonaws.services.xray.model.BatchGetTracesResult;
import com.amazonaws.services.xray.model.GetServiceGraphRequest;
import com.amazonaws.services.xray.model.GetServiceGraphResult;
import com.amazonaws.services.xray.model.GetTraceGraphRequest;
import com.amazonaws.services.xray.model.GetTraceGraphResult;
import com.amazonaws.services.xray.model.GetTraceSummariesRequest;
import com.amazonaws.services.xray.model.GetTraceSummariesResult;
import com.amazonaws.services.xray.model.PutTelemetryRecordsRequest;
import com.amazonaws.services.xray.model.PutTelemetryRecordsResult;
import com.amazonaws.services.xray.model.PutTraceSegmentsRequest;
import com.amazonaws.services.xray.model.PutTraceSegmentsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSXRayAsyncClient
extends AWSXRayClient
implements AWSXRayAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSXRayAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSXRayAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSXRayAsyncClientBuilder asyncBuilder() {
        return AWSXRayAsyncClientBuilder.standard();
    }

    AWSXRayAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetTracesResult> batchGetTracesAsync(BatchGetTracesRequest request) {
        return this.batchGetTracesAsync(request, null);
    }

    @Override
    public Future<BatchGetTracesResult> batchGetTracesAsync(BatchGetTracesRequest request, final AsyncHandler<BatchGetTracesRequest, BatchGetTracesResult> asyncHandler) {
        final BatchGetTracesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetTracesResult>(){

            @Override
            public BatchGetTracesResult call() throws Exception {
                BatchGetTracesResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeBatchGetTraces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetServiceGraphResult> getServiceGraphAsync(GetServiceGraphRequest request) {
        return this.getServiceGraphAsync(request, null);
    }

    @Override
    public Future<GetServiceGraphResult> getServiceGraphAsync(GetServiceGraphRequest request, final AsyncHandler<GetServiceGraphRequest, GetServiceGraphResult> asyncHandler) {
        final GetServiceGraphRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetServiceGraphResult>(){

            @Override
            public GetServiceGraphResult call() throws Exception {
                GetServiceGraphResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetServiceGraph(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTraceGraphResult> getTraceGraphAsync(GetTraceGraphRequest request) {
        return this.getTraceGraphAsync(request, null);
    }

    @Override
    public Future<GetTraceGraphResult> getTraceGraphAsync(GetTraceGraphRequest request, final AsyncHandler<GetTraceGraphRequest, GetTraceGraphResult> asyncHandler) {
        final GetTraceGraphRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTraceGraphResult>(){

            @Override
            public GetTraceGraphResult call() throws Exception {
                GetTraceGraphResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetTraceGraph(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTraceSummariesResult> getTraceSummariesAsync(GetTraceSummariesRequest request) {
        return this.getTraceSummariesAsync(request, null);
    }

    @Override
    public Future<GetTraceSummariesResult> getTraceSummariesAsync(GetTraceSummariesRequest request, final AsyncHandler<GetTraceSummariesRequest, GetTraceSummariesResult> asyncHandler) {
        final GetTraceSummariesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTraceSummariesResult>(){

            @Override
            public GetTraceSummariesResult call() throws Exception {
                GetTraceSummariesResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetTraceSummaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTelemetryRecordsResult> putTelemetryRecordsAsync(PutTelemetryRecordsRequest request) {
        return this.putTelemetryRecordsAsync(request, null);
    }

    @Override
    public Future<PutTelemetryRecordsResult> putTelemetryRecordsAsync(PutTelemetryRecordsRequest request, final AsyncHandler<PutTelemetryRecordsRequest, PutTelemetryRecordsResult> asyncHandler) {
        final PutTelemetryRecordsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutTelemetryRecordsResult>(){

            @Override
            public PutTelemetryRecordsResult call() throws Exception {
                PutTelemetryRecordsResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executePutTelemetryRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTraceSegmentsResult> putTraceSegmentsAsync(PutTraceSegmentsRequest request) {
        return this.putTraceSegmentsAsync(request, null);
    }

    @Override
    public Future<PutTraceSegmentsResult> putTraceSegmentsAsync(PutTraceSegmentsRequest request, final AsyncHandler<PutTraceSegmentsRequest, PutTraceSegmentsResult> asyncHandler) {
        final PutTraceSegmentsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutTraceSegmentsResult>(){

            @Override
            public PutTraceSegmentsResult call() throws Exception {
                PutTraceSegmentsResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executePutTraceSegments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

