/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    @Override
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        if (describeSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSnapshotsRequest> request = new DefaultRequest<DescribeSnapshotsRequest>(describeSnapshotsRequest, "AmazonElastiCache");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSnapshotsRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString(describeSnapshotsRequest.getReplicationGroupId()));
        }
        if (describeSnapshotsRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString(describeSnapshotsRequest.getCacheClusterId()));
        }
        if (describeSnapshotsRequest.getSnapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString(describeSnapshotsRequest.getSnapshotName()));
        }
        if (describeSnapshotsRequest.getSnapshotSource() != null) {
            request.addParameter("SnapshotSource", StringUtils.fromString(describeSnapshotsRequest.getSnapshotSource()));
        }
        if (describeSnapshotsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeSnapshotsRequest.getMarker()));
        }
        if (describeSnapshotsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeSnapshotsRequest.getMaxRecords()));
        }
        if (describeSnapshotsRequest.getShowNodeGroupConfig() != null) {
            request.addParameter("ShowNodeGroupConfig", StringUtils.fromBoolean(describeSnapshotsRequest.getShowNodeGroupConfig()));
        }
        return request;
    }
}

