/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.services.cloudsearchv2.model.AnalysisOptions;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AnalysisOptionsStaxUnmarshaller
implements Unmarshaller<AnalysisOptions, StaxUnmarshallerContext> {
    private static AnalysisOptionsStaxUnmarshaller instance;

    @Override
    public AnalysisOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        AnalysisOptions analysisOptions = new AnalysisOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return analysisOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Synonyms", targetDepth)) {
                    analysisOptions.setSynonyms(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Stopwords", targetDepth)) {
                    analysisOptions.setStopwords(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StemmingDictionary", targetDepth)) {
                    analysisOptions.setStemmingDictionary(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("JapaneseTokenizationDictionary", targetDepth)) {
                    analysisOptions.setJapaneseTokenizationDictionary(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AlgorithmicStemming", targetDepth)) continue;
                analysisOptions.setAlgorithmicStemming(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return analysisOptions;
    }

    public static AnalysisOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AnalysisOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

