/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.workspaces.AmazonWorkspaces;
import com.amazonaws.services.workspaces.AmazonWorkspacesClientBuilder;
import com.amazonaws.services.workspaces.model.AccessDeniedException;
import com.amazonaws.services.workspaces.model.AmazonWorkspacesException;
import com.amazonaws.services.workspaces.model.CreateTagsRequest;
import com.amazonaws.services.workspaces.model.CreateTagsResult;
import com.amazonaws.services.workspaces.model.CreateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.CreateWorkspacesResult;
import com.amazonaws.services.workspaces.model.DeleteTagsRequest;
import com.amazonaws.services.workspaces.model.DeleteTagsResult;
import com.amazonaws.services.workspaces.model.DescribeTagsRequest;
import com.amazonaws.services.workspaces.model.DescribeTagsResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesConnectionStatusResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesResult;
import com.amazonaws.services.workspaces.model.InvalidParameterValuesException;
import com.amazonaws.services.workspaces.model.InvalidResourceStateException;
import com.amazonaws.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import com.amazonaws.services.workspaces.model.ModifyWorkspacePropertiesResult;
import com.amazonaws.services.workspaces.model.OperationInProgressException;
import com.amazonaws.services.workspaces.model.RebootWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebootWorkspacesResult;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesResult;
import com.amazonaws.services.workspaces.model.ResourceLimitExceededException;
import com.amazonaws.services.workspaces.model.ResourceNotFoundException;
import com.amazonaws.services.workspaces.model.ResourceUnavailableException;
import com.amazonaws.services.workspaces.model.StartWorkspacesRequest;
import com.amazonaws.services.workspaces.model.StartWorkspacesResult;
import com.amazonaws.services.workspaces.model.StopWorkspacesRequest;
import com.amazonaws.services.workspaces.model.StopWorkspacesResult;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesResult;
import com.amazonaws.services.workspaces.model.UnsupportedWorkspaceConfigurationException;
import com.amazonaws.services.workspaces.model.transform.CreateTagsRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.CreateTagsResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.CreateWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.CreateWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DeleteTagsRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.DeleteTagsResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeTagsRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeTagsResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspaceBundlesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspaceBundlesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspaceDirectoriesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspaceDirectoriesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspacesConnectionStatusRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspacesConnectionStatusResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.ModifyWorkspacePropertiesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.ModifyWorkspacePropertiesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.RebootWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.RebootWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.RebuildWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.RebuildWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.StartWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.StartWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.StopWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.StopWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.TerminateWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.workspaces.model.transform.TerminateWorkspacesResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonWorkspacesClient
extends AmazonWebServiceClient
implements AmazonWorkspaces {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonWorkspaces.class);
    private static final String DEFAULT_SIGNING_NAME = "workspaces";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedWorkspaceConfigurationException").withModeledClass(UnsupportedWorkspaceConfigurationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceStateException").withModeledClass(InvalidResourceStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValuesException").withModeledClass(InvalidParameterValuesException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationInProgressException").withModeledClass(OperationInProgressException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceUnavailableException").withModeledClass(ResourceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceededException").withModeledClass(ResourceLimitExceededException.class)).withBaseServiceExceptionClass(AmazonWorkspacesException.class));

    @Deprecated
    public AmazonWorkspacesClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonWorkspacesClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonWorkspacesClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonWorkspacesClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonWorkspacesClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonWorkspacesClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonWorkspacesClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonWorkspacesClientBuilder builder() {
        return AmazonWorkspacesClientBuilder.standard();
    }

    AmazonWorkspacesClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://workspaces.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/workspaces/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/workspaces/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateTagsResult createTags(CreateTagsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTagsResult executeCreateTags(CreateTagsRequest createTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTagsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTagsResult createTagsResult = (CreateTagsResult)response.getAwsResponse();
            return createTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateWorkspacesResult createWorkspaces(CreateWorkspacesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateWorkspacesResult executeCreateWorkspaces(CreateWorkspacesRequest createWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWorkspacesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateWorkspacesResult createWorkspacesResult = (CreateWorkspacesResult)response.getAwsResponse();
            return createWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTagsResult executeDeleteTags(DeleteTagsRequest deleteTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTagsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTagsResult deleteTagsResult = (DeleteTagsResult)response.getAwsResponse();
            return deleteTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTagsResult describeTags(DescribeTagsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTagsResult executeDescribeTags(DescribeTagsRequest describeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTagsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTagsResult describeTagsResult = (DescribeTagsResult)response.getAwsResponse();
            return describeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeWorkspaceBundlesResult describeWorkspaceBundles(DescribeWorkspaceBundlesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeWorkspaceBundles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeWorkspaceBundlesResult executeDescribeWorkspaceBundles(DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkspaceBundlesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkspaceBundlesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkspaceBundlesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeWorkspaceBundlesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeWorkspaceBundlesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkspaceBundlesResult describeWorkspaceBundlesResult = (DescribeWorkspaceBundlesResult)response.getAwsResponse();
            return describeWorkspaceBundlesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeWorkspaceBundlesResult describeWorkspaceBundles() {
        return this.describeWorkspaceBundles(new DescribeWorkspaceBundlesRequest());
    }

    @Override
    public DescribeWorkspaceDirectoriesResult describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeWorkspaceDirectories(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeWorkspaceDirectoriesResult executeDescribeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkspaceDirectoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkspaceDirectoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkspaceDirectoriesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeWorkspaceDirectoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeWorkspaceDirectoriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkspaceDirectoriesResult describeWorkspaceDirectoriesResult = (DescribeWorkspaceDirectoriesResult)response.getAwsResponse();
            return describeWorkspaceDirectoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeWorkspaceDirectoriesResult describeWorkspaceDirectories() {
        return this.describeWorkspaceDirectories(new DescribeWorkspaceDirectoriesRequest());
    }

    @Override
    public DescribeWorkspacesResult describeWorkspaces(DescribeWorkspacesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeWorkspacesResult executeDescribeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkspacesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkspacesResult describeWorkspacesResult = (DescribeWorkspacesResult)response.getAwsResponse();
            return describeWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeWorkspacesResult describeWorkspaces() {
        return this.describeWorkspaces(new DescribeWorkspacesRequest());
    }

    @Override
    public DescribeWorkspacesConnectionStatusResult describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeWorkspacesConnectionStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeWorkspacesConnectionStatusResult executeDescribeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkspacesConnectionStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkspacesConnectionStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkspacesConnectionStatusRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeWorkspacesConnectionStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeWorkspacesConnectionStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkspacesConnectionStatusResult describeWorkspacesConnectionStatusResult = (DescribeWorkspacesConnectionStatusResult)response.getAwsResponse();
            return describeWorkspacesConnectionStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ModifyWorkspacePropertiesResult modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeModifyWorkspaceProperties(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ModifyWorkspacePropertiesResult executeModifyWorkspaceProperties(ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyWorkspacePropertiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyWorkspacePropertiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyWorkspacePropertiesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(modifyWorkspacePropertiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ModifyWorkspacePropertiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ModifyWorkspacePropertiesResult modifyWorkspacePropertiesResult = (ModifyWorkspacePropertiesResult)response.getAwsResponse();
            return modifyWorkspacePropertiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RebootWorkspacesResult rebootWorkspaces(RebootWorkspacesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRebootWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RebootWorkspacesResult executeRebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rebootWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RebootWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RebootWorkspacesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(rebootWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RebootWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RebootWorkspacesResult rebootWorkspacesResult = (RebootWorkspacesResult)response.getAwsResponse();
            return rebootWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RebuildWorkspacesResult rebuildWorkspaces(RebuildWorkspacesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRebuildWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RebuildWorkspacesResult executeRebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rebuildWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RebuildWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RebuildWorkspacesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(rebuildWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RebuildWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RebuildWorkspacesResult rebuildWorkspacesResult = (RebuildWorkspacesResult)response.getAwsResponse();
            return rebuildWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartWorkspacesResult startWorkspaces(StartWorkspacesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartWorkspacesResult executeStartWorkspaces(StartWorkspacesRequest startWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartWorkspacesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(startWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartWorkspacesResult startWorkspacesResult = (StartWorkspacesResult)response.getAwsResponse();
            return startWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopWorkspacesResult stopWorkspaces(StopWorkspacesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStopWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopWorkspacesResult executeStopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopWorkspacesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(stopWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopWorkspacesResult stopWorkspacesResult = (StopWorkspacesResult)response.getAwsResponse();
            return stopWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TerminateWorkspacesResult terminateWorkspaces(TerminateWorkspacesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTerminateWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TerminateWorkspacesResult executeTerminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(terminateWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TerminateWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TerminateWorkspacesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(terminateWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TerminateWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TerminateWorkspacesResult terminateWorkspacesResult = (TerminateWorkspacesResult)response.getAwsResponse();
            return terminateWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

