/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.waf.model.WafAction;
import com.amazonaws.services.waf.model.WebACLUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateWebACLRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String webACLId;
    private String changeToken;
    private List<WebACLUpdate> updates;
    private WafAction defaultAction;

    public void setWebACLId(String webACLId) {
        this.webACLId = webACLId;
    }

    public String getWebACLId() {
        return this.webACLId;
    }

    public UpdateWebACLRequest withWebACLId(String webACLId) {
        this.setWebACLId(webACLId);
        return this;
    }

    public void setChangeToken(String changeToken) {
        this.changeToken = changeToken;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public UpdateWebACLRequest withChangeToken(String changeToken) {
        this.setChangeToken(changeToken);
        return this;
    }

    public List<WebACLUpdate> getUpdates() {
        return this.updates;
    }

    public void setUpdates(Collection<WebACLUpdate> updates) {
        if (updates == null) {
            this.updates = null;
            return;
        }
        this.updates = new ArrayList<WebACLUpdate>(updates);
    }

    public UpdateWebACLRequest withUpdates(WebACLUpdate ... updates) {
        if (this.updates == null) {
            this.setUpdates(new ArrayList<WebACLUpdate>(updates.length));
        }
        for (WebACLUpdate ele : updates) {
            this.updates.add(ele);
        }
        return this;
    }

    public UpdateWebACLRequest withUpdates(Collection<WebACLUpdate> updates) {
        this.setUpdates(updates);
        return this;
    }

    public void setDefaultAction(WafAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public WafAction getDefaultAction() {
        return this.defaultAction;
    }

    public UpdateWebACLRequest withDefaultAction(WafAction defaultAction) {
        this.setDefaultAction(defaultAction);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWebACLId() != null) {
            sb.append("WebACLId: ").append(this.getWebACLId()).append(",");
        }
        if (this.getChangeToken() != null) {
            sb.append("ChangeToken: ").append(this.getChangeToken()).append(",");
        }
        if (this.getUpdates() != null) {
            sb.append("Updates: ").append(this.getUpdates()).append(",");
        }
        if (this.getDefaultAction() != null) {
            sb.append("DefaultAction: ").append(this.getDefaultAction());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebACLRequest)) {
            return false;
        }
        UpdateWebACLRequest other = (UpdateWebACLRequest)obj;
        if (other.getWebACLId() == null ^ this.getWebACLId() == null) {
            return false;
        }
        if (other.getWebACLId() != null && !other.getWebACLId().equals(this.getWebACLId())) {
            return false;
        }
        if (other.getChangeToken() == null ^ this.getChangeToken() == null) {
            return false;
        }
        if (other.getChangeToken() != null && !other.getChangeToken().equals(this.getChangeToken())) {
            return false;
        }
        if (other.getUpdates() == null ^ this.getUpdates() == null) {
            return false;
        }
        if (other.getUpdates() != null && !other.getUpdates().equals(this.getUpdates())) {
            return false;
        }
        if (other.getDefaultAction() == null ^ this.getDefaultAction() == null) {
            return false;
        }
        return other.getDefaultAction() == null || other.getDefaultAction().equals(this.getDefaultAction());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWebACLId() == null ? 0 : this.getWebACLId().hashCode());
        hashCode = 31 * hashCode + (this.getChangeToken() == null ? 0 : this.getChangeToken().hashCode());
        hashCode = 31 * hashCode + (this.getUpdates() == null ? 0 : this.getUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultAction() == null ? 0 : this.getDefaultAction().hashCode());
        return hashCode;
    }

    @Override
    public UpdateWebACLRequest clone() {
        return (UpdateWebACLRequest)super.clone();
    }
}

