/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.SystemStatus;
import com.amazonaws.services.elasticbeanstalk.model.transform.CPUUtilizationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class SystemStatusStaxUnmarshaller
implements Unmarshaller<SystemStatus, StaxUnmarshallerContext> {
    private static SystemStatusStaxUnmarshaller instance;

    @Override
    public SystemStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        SystemStatus systemStatus = new SystemStatus();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return systemStatus;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CPUUtilization", targetDepth)) {
                    systemStatus.setCPUUtilization(CPUUtilizationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LoadAverage", targetDepth)) {
                    systemStatus.withLoadAverage(new ArrayList<Double>());
                    continue;
                }
                if (!context.testExpression("LoadAverage/member", targetDepth)) continue;
                systemStatus.withLoadAverage(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return systemStatus;
    }

    public static SystemStatusStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SystemStatusStaxUnmarshaller();
        }
        return instance;
    }
}

