/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeTasksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<String> tasks;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public DescribeTasksRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<String> getTasks() {
        if (this.tasks == null) {
            this.tasks = new SdkInternalList();
        }
        return this.tasks;
    }

    public void setTasks(Collection<String> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        this.tasks = new SdkInternalList<String>(tasks);
    }

    public DescribeTasksRequest withTasks(String ... tasks) {
        if (this.tasks == null) {
            this.setTasks(new SdkInternalList<String>(tasks.length));
        }
        for (String ele : tasks) {
            this.tasks.add(ele);
        }
        return this;
    }

    public DescribeTasksRequest withTasks(Collection<String> tasks) {
        this.setTasks(tasks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getTasks() != null) {
            sb.append("Tasks: ").append(this.getTasks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTasksRequest)) {
            return false;
        }
        DescribeTasksRequest other = (DescribeTasksRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        return other.getTasks() == null || other.getTasks().equals(this.getTasks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        return hashCode;
    }

    @Override
    public DescribeTasksRequest clone() {
        return (DescribeTasksRequest)super.clone();
    }
}

