/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.UpdateInstanceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateInstanceRequestMarshaller
implements Marshaller<Request<UpdateInstanceRequest>, UpdateInstanceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateInstanceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateInstanceRequest> marshall(UpdateInstanceRequest updateInstanceRequest) {
        if (updateInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateInstanceRequest> request = new DefaultRequest<UpdateInstanceRequest>(updateInstanceRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.UpdateInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList layerIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateInstanceRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(updateInstanceRequest.getInstanceId());
            }
            if (!(layerIdsList = (SdkInternalList)updateInstanceRequest.getLayerIds()).isEmpty() || !layerIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("LayerIds");
                jsonGenerator.writeStartArray();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonGenerator.writeValue(layerIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateInstanceRequest.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(updateInstanceRequest.getInstanceType());
            }
            if (updateInstanceRequest.getAutoScalingType() != null) {
                jsonGenerator.writeFieldName("AutoScalingType").writeValue(updateInstanceRequest.getAutoScalingType());
            }
            if (updateInstanceRequest.getHostname() != null) {
                jsonGenerator.writeFieldName("Hostname").writeValue(updateInstanceRequest.getHostname());
            }
            if (updateInstanceRequest.getOs() != null) {
                jsonGenerator.writeFieldName("Os").writeValue(updateInstanceRequest.getOs());
            }
            if (updateInstanceRequest.getAmiId() != null) {
                jsonGenerator.writeFieldName("AmiId").writeValue(updateInstanceRequest.getAmiId());
            }
            if (updateInstanceRequest.getSshKeyName() != null) {
                jsonGenerator.writeFieldName("SshKeyName").writeValue(updateInstanceRequest.getSshKeyName());
            }
            if (updateInstanceRequest.getArchitecture() != null) {
                jsonGenerator.writeFieldName("Architecture").writeValue(updateInstanceRequest.getArchitecture());
            }
            if (updateInstanceRequest.getInstallUpdatesOnBoot() != null) {
                jsonGenerator.writeFieldName("InstallUpdatesOnBoot").writeValue(updateInstanceRequest.getInstallUpdatesOnBoot());
            }
            if (updateInstanceRequest.getEbsOptimized() != null) {
                jsonGenerator.writeFieldName("EbsOptimized").writeValue(updateInstanceRequest.getEbsOptimized());
            }
            if (updateInstanceRequest.getAgentVersion() != null) {
                jsonGenerator.writeFieldName("AgentVersion").writeValue(updateInstanceRequest.getAgentVersion());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

