/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeElasticsearchDomainRequestMarshaller
implements Marshaller<Request<DescribeElasticsearchDomainRequest>, DescribeElasticsearchDomainRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeElasticsearchDomainRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeElasticsearchDomainRequest> marshall(DescribeElasticsearchDomainRequest describeElasticsearchDomainRequest) {
        if (describeElasticsearchDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeElasticsearchDomainRequest> request = new DefaultRequest<DescribeElasticsearchDomainRequest>(describeElasticsearchDomainRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-01-01/es/domain/{DomainName}";
        uriResourcePath = uriResourcePath.replace("{DomainName}", describeElasticsearchDomainRequest.getDomainName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeElasticsearchDomainRequest.getDomainName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

