/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DescribeDeploymentsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeDeploymentsRequestMarshaller
implements Marshaller<Request<DescribeDeploymentsRequest>, DescribeDeploymentsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeDeploymentsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeDeploymentsRequest> marshall(DescribeDeploymentsRequest describeDeploymentsRequest) {
        if (describeDeploymentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDeploymentsRequest> request = new DefaultRequest<DescribeDeploymentsRequest>(describeDeploymentsRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeDeployments");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList deploymentIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeDeploymentsRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeDeploymentsRequest.getStackId());
            }
            if (describeDeploymentsRequest.getAppId() != null) {
                jsonGenerator.writeFieldName("AppId").writeValue(describeDeploymentsRequest.getAppId());
            }
            if (!(deploymentIdsList = (SdkInternalList)describeDeploymentsRequest.getDeploymentIds()).isEmpty() || !deploymentIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DeploymentIds");
                jsonGenerator.writeStartArray();
                for (String deploymentIdsListValue : deploymentIdsList) {
                    if (deploymentIdsListValue == null) continue;
                    jsonGenerator.writeValue(deploymentIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

