/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteFunctionRequestMarshaller
implements Marshaller<Request<DeleteFunctionRequest>, DeleteFunctionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteFunctionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteFunctionRequest> marshall(DeleteFunctionRequest deleteFunctionRequest) {
        if (deleteFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteFunctionRequest> request = new DefaultRequest<DeleteFunctionRequest>(deleteFunctionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", deleteFunctionRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteFunctionRequest.getFunctionName()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (deleteFunctionRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString(deleteFunctionRequest.getQualifier()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

