/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotdata.model.UpdateThingShadowRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class UpdateThingShadowRequestMarshaller
implements Marshaller<Request<UpdateThingShadowRequest>, UpdateThingShadowRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateThingShadowRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateThingShadowRequest> marshall(UpdateThingShadowRequest updateThingShadowRequest) {
        if (updateThingShadowRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateThingShadowRequest> request = new DefaultRequest<UpdateThingShadowRequest>(updateThingShadowRequest, "AWSIotData");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/things/{thingName}/shadow";
        uriResourcePath = uriResourcePath.replace("{thingName}", updateThingShadowRequest.getThingName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateThingShadowRequest.getThingName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(BinaryUtils.toStream(updateThingShadowRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

