/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotdata.model.GetThingShadowRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetThingShadowRequestMarshaller
implements Marshaller<Request<GetThingShadowRequest>, GetThingShadowRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public GetThingShadowRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetThingShadowRequest> marshall(GetThingShadowRequest getThingShadowRequest) {
        if (getThingShadowRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetThingShadowRequest> request = new DefaultRequest<GetThingShadowRequest>(getThingShadowRequest, "AWSIotData");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/things/{thingName}/shadow";
        uriResourcePath = uriResourcePath.replace("{thingName}", getThingShadowRequest.getThingName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getThingShadowRequest.getThingName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

