/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.CreatePolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreatePolicyVersionRequestMarshaller
implements Marshaller<Request<CreatePolicyVersionRequest>, CreatePolicyVersionRequest> {
    @Override
    public Request<CreatePolicyVersionRequest> marshall(CreatePolicyVersionRequest createPolicyVersionRequest) {
        if (createPolicyVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePolicyVersionRequest> request = new DefaultRequest<CreatePolicyVersionRequest>(createPolicyVersionRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreatePolicyVersion");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPolicyVersionRequest.getPolicyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString(createPolicyVersionRequest.getPolicyArn()));
        }
        if (createPolicyVersionRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(createPolicyVersionRequest.getPolicyDocument()));
        }
        if (createPolicyVersionRequest.getSetAsDefault() != null) {
            request.addParameter("SetAsDefault", StringUtils.fromBoolean(createPolicyVersionRequest.getSetAsDefault()));
        }
        return request;
    }
}

