/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.DescribeFleetEventsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeFleetEventsRequestMarshaller
implements Marshaller<Request<DescribeFleetEventsRequest>, DescribeFleetEventsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeFleetEventsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeFleetEventsRequest> marshall(DescribeFleetEventsRequest describeFleetEventsRequest) {
        if (describeFleetEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetEventsRequest> request = new DefaultRequest<DescribeFleetEventsRequest>(describeFleetEventsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeFleetEvents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeFleetEventsRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(describeFleetEventsRequest.getFleetId());
            }
            if (describeFleetEventsRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(describeFleetEventsRequest.getStartTime());
            }
            if (describeFleetEventsRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(describeFleetEventsRequest.getEndTime());
            }
            if (describeFleetEventsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeFleetEventsRequest.getLimit());
            }
            if (describeFleetEventsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeFleetEventsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

