/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.ReplicationInstance;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationPendingModifiedValuesJsonMarshaller;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationSubnetGroupJsonMarshaller;

public class ReplicationInstanceJsonMarshaller {
    private static ReplicationInstanceJsonMarshaller instance;

    public void marshall(ReplicationInstance replicationInstance, StructuredJsonGenerator jsonGenerator) {
        if (replicationInstance == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (replicationInstance.getReplicationInstanceIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceIdentifier").writeValue(replicationInstance.getReplicationInstanceIdentifier());
            }
            if (replicationInstance.getReplicationInstanceClass() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceClass").writeValue(replicationInstance.getReplicationInstanceClass());
            }
            if (replicationInstance.getReplicationInstanceStatus() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceStatus").writeValue(replicationInstance.getReplicationInstanceStatus());
            }
            if (replicationInstance.getAllocatedStorage() != null) {
                jsonGenerator.writeFieldName("AllocatedStorage").writeValue(replicationInstance.getAllocatedStorage());
            }
            if (replicationInstance.getInstanceCreateTime() != null) {
                jsonGenerator.writeFieldName("InstanceCreateTime").writeValue(replicationInstance.getInstanceCreateTime());
            }
            if (replicationInstance.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("AvailabilityZone").writeValue(replicationInstance.getAvailabilityZone());
            }
            if (replicationInstance.getReplicationSubnetGroup() != null) {
                jsonGenerator.writeFieldName("ReplicationSubnetGroup");
                ReplicationSubnetGroupJsonMarshaller.getInstance().marshall(replicationInstance.getReplicationSubnetGroup(), jsonGenerator);
            }
            if (replicationInstance.getPreferredMaintenanceWindow() != null) {
                jsonGenerator.writeFieldName("PreferredMaintenanceWindow").writeValue(replicationInstance.getPreferredMaintenanceWindow());
            }
            if (replicationInstance.getPendingModifiedValues() != null) {
                jsonGenerator.writeFieldName("PendingModifiedValues");
                ReplicationPendingModifiedValuesJsonMarshaller.getInstance().marshall(replicationInstance.getPendingModifiedValues(), jsonGenerator);
            }
            if (replicationInstance.getEngineVersion() != null) {
                jsonGenerator.writeFieldName("EngineVersion").writeValue(replicationInstance.getEngineVersion());
            }
            if (replicationInstance.getAutoMinorVersionUpgrade() != null) {
                jsonGenerator.writeFieldName("AutoMinorVersionUpgrade").writeValue(replicationInstance.getAutoMinorVersionUpgrade());
            }
            if (replicationInstance.getKmsKeyId() != null) {
                jsonGenerator.writeFieldName("KmsKeyId").writeValue(replicationInstance.getKmsKeyId());
            }
            if (replicationInstance.getReplicationInstanceArn() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceArn").writeValue(replicationInstance.getReplicationInstanceArn());
            }
            if (replicationInstance.getReplicationInstancePublicIpAddress() != null) {
                jsonGenerator.writeFieldName("ReplicationInstancePublicIpAddress").writeValue(replicationInstance.getReplicationInstancePublicIpAddress());
            }
            if (replicationInstance.getReplicationInstancePrivateIpAddress() != null) {
                jsonGenerator.writeFieldName("ReplicationInstancePrivateIpAddress").writeValue(replicationInstance.getReplicationInstancePrivateIpAddress());
            }
            if (replicationInstance.getPubliclyAccessible() != null) {
                jsonGenerator.writeFieldName("PubliclyAccessible").writeValue(replicationInstance.getPubliclyAccessible());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReplicationInstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReplicationInstanceJsonMarshaller();
        }
        return instance;
    }
}

