/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AdminResetUserPasswordRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AdminResetUserPasswordRequestMarshaller
implements Marshaller<Request<AdminResetUserPasswordRequest>, AdminResetUserPasswordRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AdminResetUserPasswordRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AdminResetUserPasswordRequest> marshall(AdminResetUserPasswordRequest adminResetUserPasswordRequest) {
        if (adminResetUserPasswordRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AdminResetUserPasswordRequest> request = new DefaultRequest<AdminResetUserPasswordRequest>(adminResetUserPasswordRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminResetUserPassword");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (adminResetUserPasswordRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminResetUserPasswordRequest.getUserPoolId());
            }
            if (adminResetUserPasswordRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(adminResetUserPasswordRequest.getUsername());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

