/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.PutActionRevisionRequest;
import com.amazonaws.services.codepipeline.model.transform.ActionRevisionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PutActionRevisionRequestMarshaller
implements Marshaller<Request<PutActionRevisionRequest>, PutActionRevisionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutActionRevisionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutActionRevisionRequest> marshall(PutActionRevisionRequest putActionRevisionRequest) {
        if (putActionRevisionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutActionRevisionRequest> request = new DefaultRequest<PutActionRevisionRequest>(putActionRevisionRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.PutActionRevision");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putActionRevisionRequest.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(putActionRevisionRequest.getPipelineName());
            }
            if (putActionRevisionRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(putActionRevisionRequest.getStageName());
            }
            if (putActionRevisionRequest.getActionName() != null) {
                jsonGenerator.writeFieldName("actionName").writeValue(putActionRevisionRequest.getActionName());
            }
            if (putActionRevisionRequest.getActionRevision() != null) {
                jsonGenerator.writeFieldName("actionRevision");
                ActionRevisionJsonMarshaller.getInstance().marshall(putActionRevisionRequest.getActionRevision(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

