/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.Diagnostics;

public class DiagnosticsJsonMarshaller {
    private static DiagnosticsJsonMarshaller instance;

    public void marshall(Diagnostics diagnostics, StructuredJsonGenerator jsonGenerator) {
        if (diagnostics == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (diagnostics.getErrorCode() != null) {
                jsonGenerator.writeFieldName("errorCode").writeValue(diagnostics.getErrorCode());
            }
            if (diagnostics.getScriptName() != null) {
                jsonGenerator.writeFieldName("scriptName").writeValue(diagnostics.getScriptName());
            }
            if (diagnostics.getMessage() != null) {
                jsonGenerator.writeFieldName("message").writeValue(diagnostics.getMessage());
            }
            if (diagnostics.getLogTail() != null) {
                jsonGenerator.writeFieldName("logTail").writeValue(diagnostics.getLogTail());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DiagnosticsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DiagnosticsJsonMarshaller();
        }
        return instance;
    }
}

