/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.certificatemanager.model.ListCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class ListCertificatesRequestMarshaller
implements Marshaller<Request<ListCertificatesRequest>, ListCertificatesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListCertificatesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListCertificatesRequest> marshall(ListCertificatesRequest listCertificatesRequest) {
        if (listCertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListCertificatesRequest> request = new DefaultRequest<ListCertificatesRequest>(listCertificatesRequest, "AWSCertificateManager");
        request.addHeader("X-Amz-Target", "CertificateManager.ListCertificates");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> certificateStatusesList = listCertificatesRequest.getCertificateStatuses();
            if (certificateStatusesList != null) {
                jsonGenerator.writeFieldName("CertificateStatuses");
                jsonGenerator.writeStartArray();
                for (String certificateStatusesListValue : certificateStatusesList) {
                    if (certificateStatusesListValue == null) continue;
                    jsonGenerator.writeValue(certificateStatusesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listCertificatesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listCertificatesRequest.getNextToken());
            }
            if (listCertificatesRequest.getMaxItems() != null) {
                jsonGenerator.writeFieldName("MaxItems").writeValue(listCertificatesRequest.getMaxItems());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

