/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.certificatemanager.model.CertificateDetail;
import com.amazonaws.services.certificatemanager.model.DomainValidation;
import com.amazonaws.services.certificatemanager.model.transform.DomainValidationJsonMarshaller;
import java.util.List;

public class CertificateDetailJsonMarshaller {
    private static CertificateDetailJsonMarshaller instance;

    public void marshall(CertificateDetail certificateDetail, StructuredJsonGenerator jsonGenerator) {
        if (certificateDetail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> inUseByList;
            List<DomainValidation> domainValidationOptionsList;
            List<String> subjectAlternativeNamesList;
            jsonGenerator.writeStartObject();
            if (certificateDetail.getCertificateArn() != null) {
                jsonGenerator.writeFieldName("CertificateArn").writeValue(certificateDetail.getCertificateArn());
            }
            if (certificateDetail.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(certificateDetail.getDomainName());
            }
            if ((subjectAlternativeNamesList = certificateDetail.getSubjectAlternativeNames()) != null) {
                jsonGenerator.writeFieldName("SubjectAlternativeNames");
                jsonGenerator.writeStartArray();
                for (String subjectAlternativeNamesListValue : subjectAlternativeNamesList) {
                    if (subjectAlternativeNamesListValue == null) continue;
                    jsonGenerator.writeValue(subjectAlternativeNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((domainValidationOptionsList = certificateDetail.getDomainValidationOptions()) != null) {
                jsonGenerator.writeFieldName("DomainValidationOptions");
                jsonGenerator.writeStartArray();
                for (DomainValidation domainValidationOptionsListValue : domainValidationOptionsList) {
                    if (domainValidationOptionsListValue == null) continue;
                    DomainValidationJsonMarshaller.getInstance().marshall(domainValidationOptionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (certificateDetail.getSerial() != null) {
                jsonGenerator.writeFieldName("Serial").writeValue(certificateDetail.getSerial());
            }
            if (certificateDetail.getSubject() != null) {
                jsonGenerator.writeFieldName("Subject").writeValue(certificateDetail.getSubject());
            }
            if (certificateDetail.getIssuer() != null) {
                jsonGenerator.writeFieldName("Issuer").writeValue(certificateDetail.getIssuer());
            }
            if (certificateDetail.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(certificateDetail.getCreatedAt());
            }
            if (certificateDetail.getIssuedAt() != null) {
                jsonGenerator.writeFieldName("IssuedAt").writeValue(certificateDetail.getIssuedAt());
            }
            if (certificateDetail.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(certificateDetail.getStatus());
            }
            if (certificateDetail.getRevokedAt() != null) {
                jsonGenerator.writeFieldName("RevokedAt").writeValue(certificateDetail.getRevokedAt());
            }
            if (certificateDetail.getRevocationReason() != null) {
                jsonGenerator.writeFieldName("RevocationReason").writeValue(certificateDetail.getRevocationReason());
            }
            if (certificateDetail.getNotBefore() != null) {
                jsonGenerator.writeFieldName("NotBefore").writeValue(certificateDetail.getNotBefore());
            }
            if (certificateDetail.getNotAfter() != null) {
                jsonGenerator.writeFieldName("NotAfter").writeValue(certificateDetail.getNotAfter());
            }
            if (certificateDetail.getKeyAlgorithm() != null) {
                jsonGenerator.writeFieldName("KeyAlgorithm").writeValue(certificateDetail.getKeyAlgorithm());
            }
            if (certificateDetail.getSignatureAlgorithm() != null) {
                jsonGenerator.writeFieldName("SignatureAlgorithm").writeValue(certificateDetail.getSignatureAlgorithm());
            }
            if ((inUseByList = certificateDetail.getInUseBy()) != null) {
                jsonGenerator.writeFieldName("InUseBy");
                jsonGenerator.writeStartArray();
                for (String inUseByListValue : inUseByList) {
                    if (inUseByListValue == null) continue;
                    jsonGenerator.writeValue(inUseByListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CertificateDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CertificateDetailJsonMarshaller();
        }
        return instance;
    }
}

