/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateApiKeyRequest;
import com.amazonaws.services.apigateway.model.StageKey;
import com.amazonaws.services.apigateway.model.transform.StageKeyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateApiKeyRequestMarshaller
implements Marshaller<Request<CreateApiKeyRequest>, CreateApiKeyRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateApiKeyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateApiKeyRequest> marshall(CreateApiKeyRequest createApiKeyRequest) {
        if (createApiKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateApiKeyRequest> request = new DefaultRequest<CreateApiKeyRequest>(createApiKeyRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/apikeys";
        request.setResourcePath(uriResourcePath);
        try {
            List<StageKey> stageKeysList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createApiKeyRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createApiKeyRequest.getName());
            }
            if (createApiKeyRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createApiKeyRequest.getDescription());
            }
            if (createApiKeyRequest.getEnabled() != null) {
                jsonGenerator.writeFieldName("enabled").writeValue(createApiKeyRequest.getEnabled());
            }
            if ((stageKeysList = createApiKeyRequest.getStageKeys()) != null) {
                jsonGenerator.writeFieldName("stageKeys");
                jsonGenerator.writeStartArray();
                for (StageKey stageKeysListValue : stageKeysList) {
                    if (stageKeysListValue == null) continue;
                    StageKeyJsonMarshaller.getInstance().marshall(stageKeysListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

