/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.services.rekognition.model.Image;
import com.amazonaws.services.rekognition.model.transform.S3ObjectJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class ImageJsonUnmarshaller
implements Unmarshaller<Image, JsonUnmarshallerContext> {
    private static ImageJsonUnmarshaller instance;

    @Override
    public Image unmarshall(JsonUnmarshallerContext context) throws Exception {
        Image image = new Image();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Bytes", targetDepth)) {
                    context.nextToken();
                    image.setBytes(context.getUnmarshaller(ByteBuffer.class).unmarshall(context));
                }
                if (context.testExpression("S3Object", targetDepth)) {
                    context.nextToken();
                    image.setS3Object(S3ObjectJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return image;
    }

    public static ImageJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ImageJsonUnmarshaller();
        }
        return instance;
    }
}

