/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mturk;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mturk.AmazonMTurkAsync;
import com.amazonaws.services.mturk.AmazonMTurkAsyncClientBuilder;
import com.amazonaws.services.mturk.AmazonMTurkClient;
import com.amazonaws.services.mturk.model.AcceptQualificationRequestRequest;
import com.amazonaws.services.mturk.model.AcceptQualificationRequestResult;
import com.amazonaws.services.mturk.model.ApproveAssignmentRequest;
import com.amazonaws.services.mturk.model.ApproveAssignmentResult;
import com.amazonaws.services.mturk.model.AssociateQualificationWithWorkerRequest;
import com.amazonaws.services.mturk.model.AssociateQualificationWithWorkerResult;
import com.amazonaws.services.mturk.model.CreateAdditionalAssignmentsForHITRequest;
import com.amazonaws.services.mturk.model.CreateAdditionalAssignmentsForHITResult;
import com.amazonaws.services.mturk.model.CreateHITRequest;
import com.amazonaws.services.mturk.model.CreateHITResult;
import com.amazonaws.services.mturk.model.CreateHITTypeRequest;
import com.amazonaws.services.mturk.model.CreateHITTypeResult;
import com.amazonaws.services.mturk.model.CreateHITWithHITTypeRequest;
import com.amazonaws.services.mturk.model.CreateHITWithHITTypeResult;
import com.amazonaws.services.mturk.model.CreateQualificationTypeRequest;
import com.amazonaws.services.mturk.model.CreateQualificationTypeResult;
import com.amazonaws.services.mturk.model.CreateWorkerBlockRequest;
import com.amazonaws.services.mturk.model.CreateWorkerBlockResult;
import com.amazonaws.services.mturk.model.DeleteHITRequest;
import com.amazonaws.services.mturk.model.DeleteHITResult;
import com.amazonaws.services.mturk.model.DeleteQualificationTypeRequest;
import com.amazonaws.services.mturk.model.DeleteQualificationTypeResult;
import com.amazonaws.services.mturk.model.DeleteWorkerBlockRequest;
import com.amazonaws.services.mturk.model.DeleteWorkerBlockResult;
import com.amazonaws.services.mturk.model.DisassociateQualificationFromWorkerRequest;
import com.amazonaws.services.mturk.model.DisassociateQualificationFromWorkerResult;
import com.amazonaws.services.mturk.model.GetAccountBalanceRequest;
import com.amazonaws.services.mturk.model.GetAccountBalanceResult;
import com.amazonaws.services.mturk.model.GetAssignmentRequest;
import com.amazonaws.services.mturk.model.GetAssignmentResult;
import com.amazonaws.services.mturk.model.GetFileUploadURLRequest;
import com.amazonaws.services.mturk.model.GetFileUploadURLResult;
import com.amazonaws.services.mturk.model.GetHITRequest;
import com.amazonaws.services.mturk.model.GetHITResult;
import com.amazonaws.services.mturk.model.GetQualificationScoreRequest;
import com.amazonaws.services.mturk.model.GetQualificationScoreResult;
import com.amazonaws.services.mturk.model.GetQualificationTypeRequest;
import com.amazonaws.services.mturk.model.GetQualificationTypeResult;
import com.amazonaws.services.mturk.model.ListAssignmentsForHITRequest;
import com.amazonaws.services.mturk.model.ListAssignmentsForHITResult;
import com.amazonaws.services.mturk.model.ListBonusPaymentsRequest;
import com.amazonaws.services.mturk.model.ListBonusPaymentsResult;
import com.amazonaws.services.mturk.model.ListHITsForQualificationTypeRequest;
import com.amazonaws.services.mturk.model.ListHITsForQualificationTypeResult;
import com.amazonaws.services.mturk.model.ListHITsRequest;
import com.amazonaws.services.mturk.model.ListHITsResult;
import com.amazonaws.services.mturk.model.ListQualificationRequestsRequest;
import com.amazonaws.services.mturk.model.ListQualificationRequestsResult;
import com.amazonaws.services.mturk.model.ListQualificationTypesRequest;
import com.amazonaws.services.mturk.model.ListQualificationTypesResult;
import com.amazonaws.services.mturk.model.ListReviewPolicyResultsForHITRequest;
import com.amazonaws.services.mturk.model.ListReviewPolicyResultsForHITResult;
import com.amazonaws.services.mturk.model.ListReviewableHITsRequest;
import com.amazonaws.services.mturk.model.ListReviewableHITsResult;
import com.amazonaws.services.mturk.model.ListWorkerBlocksRequest;
import com.amazonaws.services.mturk.model.ListWorkerBlocksResult;
import com.amazonaws.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import com.amazonaws.services.mturk.model.ListWorkersWithQualificationTypeResult;
import com.amazonaws.services.mturk.model.NotifyWorkersRequest;
import com.amazonaws.services.mturk.model.NotifyWorkersResult;
import com.amazonaws.services.mturk.model.RejectAssignmentRequest;
import com.amazonaws.services.mturk.model.RejectAssignmentResult;
import com.amazonaws.services.mturk.model.RejectQualificationRequestRequest;
import com.amazonaws.services.mturk.model.RejectQualificationRequestResult;
import com.amazonaws.services.mturk.model.SendBonusRequest;
import com.amazonaws.services.mturk.model.SendBonusResult;
import com.amazonaws.services.mturk.model.SendTestEventNotificationRequest;
import com.amazonaws.services.mturk.model.SendTestEventNotificationResult;
import com.amazonaws.services.mturk.model.UpdateExpirationForHITRequest;
import com.amazonaws.services.mturk.model.UpdateExpirationForHITResult;
import com.amazonaws.services.mturk.model.UpdateHITReviewStatusRequest;
import com.amazonaws.services.mturk.model.UpdateHITReviewStatusResult;
import com.amazonaws.services.mturk.model.UpdateHITTypeOfHITRequest;
import com.amazonaws.services.mturk.model.UpdateHITTypeOfHITResult;
import com.amazonaws.services.mturk.model.UpdateNotificationSettingsRequest;
import com.amazonaws.services.mturk.model.UpdateNotificationSettingsResult;
import com.amazonaws.services.mturk.model.UpdateQualificationTypeRequest;
import com.amazonaws.services.mturk.model.UpdateQualificationTypeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMTurkAsyncClient
extends AmazonMTurkClient
implements AmazonMTurkAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonMTurkAsyncClientBuilder asyncBuilder() {
        return AmazonMTurkAsyncClientBuilder.standard();
    }

    AmazonMTurkAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptQualificationRequestResult> acceptQualificationRequestAsync(AcceptQualificationRequestRequest request) {
        return this.acceptQualificationRequestAsync(request, null);
    }

    @Override
    public Future<AcceptQualificationRequestResult> acceptQualificationRequestAsync(final AcceptQualificationRequestRequest request, final AsyncHandler<AcceptQualificationRequestRequest, AcceptQualificationRequestResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcceptQualificationRequestResult>(){

            @Override
            public AcceptQualificationRequestResult call() throws Exception {
                AcceptQualificationRequestResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.acceptQualificationRequest(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ApproveAssignmentResult> approveAssignmentAsync(ApproveAssignmentRequest request) {
        return this.approveAssignmentAsync(request, null);
    }

    @Override
    public Future<ApproveAssignmentResult> approveAssignmentAsync(final ApproveAssignmentRequest request, final AsyncHandler<ApproveAssignmentRequest, ApproveAssignmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<ApproveAssignmentResult>(){

            @Override
            public ApproveAssignmentResult call() throws Exception {
                ApproveAssignmentResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.approveAssignment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateQualificationWithWorkerResult> associateQualificationWithWorkerAsync(AssociateQualificationWithWorkerRequest request) {
        return this.associateQualificationWithWorkerAsync(request, null);
    }

    @Override
    public Future<AssociateQualificationWithWorkerResult> associateQualificationWithWorkerAsync(final AssociateQualificationWithWorkerRequest request, final AsyncHandler<AssociateQualificationWithWorkerRequest, AssociateQualificationWithWorkerResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssociateQualificationWithWorkerResult>(){

            @Override
            public AssociateQualificationWithWorkerResult call() throws Exception {
                AssociateQualificationWithWorkerResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.associateQualificationWithWorker(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAdditionalAssignmentsForHITResult> createAdditionalAssignmentsForHITAsync(CreateAdditionalAssignmentsForHITRequest request) {
        return this.createAdditionalAssignmentsForHITAsync(request, null);
    }

    @Override
    public Future<CreateAdditionalAssignmentsForHITResult> createAdditionalAssignmentsForHITAsync(final CreateAdditionalAssignmentsForHITRequest request, final AsyncHandler<CreateAdditionalAssignmentsForHITRequest, CreateAdditionalAssignmentsForHITResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAdditionalAssignmentsForHITResult>(){

            @Override
            public CreateAdditionalAssignmentsForHITResult call() throws Exception {
                CreateAdditionalAssignmentsForHITResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.createAdditionalAssignmentsForHIT(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHITResult> createHITAsync(CreateHITRequest request) {
        return this.createHITAsync(request, null);
    }

    @Override
    public Future<CreateHITResult> createHITAsync(final CreateHITRequest request, final AsyncHandler<CreateHITRequest, CreateHITResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateHITResult>(){

            @Override
            public CreateHITResult call() throws Exception {
                CreateHITResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.createHIT(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHITTypeResult> createHITTypeAsync(CreateHITTypeRequest request) {
        return this.createHITTypeAsync(request, null);
    }

    @Override
    public Future<CreateHITTypeResult> createHITTypeAsync(final CreateHITTypeRequest request, final AsyncHandler<CreateHITTypeRequest, CreateHITTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateHITTypeResult>(){

            @Override
            public CreateHITTypeResult call() throws Exception {
                CreateHITTypeResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.createHITType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHITWithHITTypeResult> createHITWithHITTypeAsync(CreateHITWithHITTypeRequest request) {
        return this.createHITWithHITTypeAsync(request, null);
    }

    @Override
    public Future<CreateHITWithHITTypeResult> createHITWithHITTypeAsync(final CreateHITWithHITTypeRequest request, final AsyncHandler<CreateHITWithHITTypeRequest, CreateHITWithHITTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateHITWithHITTypeResult>(){

            @Override
            public CreateHITWithHITTypeResult call() throws Exception {
                CreateHITWithHITTypeResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.createHITWithHITType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateQualificationTypeResult> createQualificationTypeAsync(CreateQualificationTypeRequest request) {
        return this.createQualificationTypeAsync(request, null);
    }

    @Override
    public Future<CreateQualificationTypeResult> createQualificationTypeAsync(final CreateQualificationTypeRequest request, final AsyncHandler<CreateQualificationTypeRequest, CreateQualificationTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateQualificationTypeResult>(){

            @Override
            public CreateQualificationTypeResult call() throws Exception {
                CreateQualificationTypeResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.createQualificationType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkerBlockResult> createWorkerBlockAsync(CreateWorkerBlockRequest request) {
        return this.createWorkerBlockAsync(request, null);
    }

    @Override
    public Future<CreateWorkerBlockResult> createWorkerBlockAsync(final CreateWorkerBlockRequest request, final AsyncHandler<CreateWorkerBlockRequest, CreateWorkerBlockResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateWorkerBlockResult>(){

            @Override
            public CreateWorkerBlockResult call() throws Exception {
                CreateWorkerBlockResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.createWorkerBlock(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHITResult> deleteHITAsync(DeleteHITRequest request) {
        return this.deleteHITAsync(request, null);
    }

    @Override
    public Future<DeleteHITResult> deleteHITAsync(final DeleteHITRequest request, final AsyncHandler<DeleteHITRequest, DeleteHITResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteHITResult>(){

            @Override
            public DeleteHITResult call() throws Exception {
                DeleteHITResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.deleteHIT(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteQualificationTypeResult> deleteQualificationTypeAsync(DeleteQualificationTypeRequest request) {
        return this.deleteQualificationTypeAsync(request, null);
    }

    @Override
    public Future<DeleteQualificationTypeResult> deleteQualificationTypeAsync(final DeleteQualificationTypeRequest request, final AsyncHandler<DeleteQualificationTypeRequest, DeleteQualificationTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteQualificationTypeResult>(){

            @Override
            public DeleteQualificationTypeResult call() throws Exception {
                DeleteQualificationTypeResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.deleteQualificationType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkerBlockResult> deleteWorkerBlockAsync(DeleteWorkerBlockRequest request) {
        return this.deleteWorkerBlockAsync(request, null);
    }

    @Override
    public Future<DeleteWorkerBlockResult> deleteWorkerBlockAsync(final DeleteWorkerBlockRequest request, final AsyncHandler<DeleteWorkerBlockRequest, DeleteWorkerBlockResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteWorkerBlockResult>(){

            @Override
            public DeleteWorkerBlockResult call() throws Exception {
                DeleteWorkerBlockResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.deleteWorkerBlock(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateQualificationFromWorkerResult> disassociateQualificationFromWorkerAsync(DisassociateQualificationFromWorkerRequest request) {
        return this.disassociateQualificationFromWorkerAsync(request, null);
    }

    @Override
    public Future<DisassociateQualificationFromWorkerResult> disassociateQualificationFromWorkerAsync(final DisassociateQualificationFromWorkerRequest request, final AsyncHandler<DisassociateQualificationFromWorkerRequest, DisassociateQualificationFromWorkerResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisassociateQualificationFromWorkerResult>(){

            @Override
            public DisassociateQualificationFromWorkerResult call() throws Exception {
                DisassociateQualificationFromWorkerResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.disassociateQualificationFromWorker(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountBalanceResult> getAccountBalanceAsync(GetAccountBalanceRequest request) {
        return this.getAccountBalanceAsync(request, null);
    }

    @Override
    public Future<GetAccountBalanceResult> getAccountBalanceAsync(final GetAccountBalanceRequest request, final AsyncHandler<GetAccountBalanceRequest, GetAccountBalanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetAccountBalanceResult>(){

            @Override
            public GetAccountBalanceResult call() throws Exception {
                GetAccountBalanceResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.getAccountBalance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAssignmentResult> getAssignmentAsync(GetAssignmentRequest request) {
        return this.getAssignmentAsync(request, null);
    }

    @Override
    public Future<GetAssignmentResult> getAssignmentAsync(final GetAssignmentRequest request, final AsyncHandler<GetAssignmentRequest, GetAssignmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetAssignmentResult>(){

            @Override
            public GetAssignmentResult call() throws Exception {
                GetAssignmentResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.getAssignment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFileUploadURLResult> getFileUploadURLAsync(GetFileUploadURLRequest request) {
        return this.getFileUploadURLAsync(request, null);
    }

    @Override
    public Future<GetFileUploadURLResult> getFileUploadURLAsync(final GetFileUploadURLRequest request, final AsyncHandler<GetFileUploadURLRequest, GetFileUploadURLResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetFileUploadURLResult>(){

            @Override
            public GetFileUploadURLResult call() throws Exception {
                GetFileUploadURLResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.getFileUploadURL(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHITResult> getHITAsync(GetHITRequest request) {
        return this.getHITAsync(request, null);
    }

    @Override
    public Future<GetHITResult> getHITAsync(final GetHITRequest request, final AsyncHandler<GetHITRequest, GetHITResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetHITResult>(){

            @Override
            public GetHITResult call() throws Exception {
                GetHITResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.getHIT(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQualificationScoreResult> getQualificationScoreAsync(GetQualificationScoreRequest request) {
        return this.getQualificationScoreAsync(request, null);
    }

    @Override
    public Future<GetQualificationScoreResult> getQualificationScoreAsync(final GetQualificationScoreRequest request, final AsyncHandler<GetQualificationScoreRequest, GetQualificationScoreResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetQualificationScoreResult>(){

            @Override
            public GetQualificationScoreResult call() throws Exception {
                GetQualificationScoreResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.getQualificationScore(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQualificationTypeResult> getQualificationTypeAsync(GetQualificationTypeRequest request) {
        return this.getQualificationTypeAsync(request, null);
    }

    @Override
    public Future<GetQualificationTypeResult> getQualificationTypeAsync(final GetQualificationTypeRequest request, final AsyncHandler<GetQualificationTypeRequest, GetQualificationTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetQualificationTypeResult>(){

            @Override
            public GetQualificationTypeResult call() throws Exception {
                GetQualificationTypeResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.getQualificationType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssignmentsForHITResult> listAssignmentsForHITAsync(ListAssignmentsForHITRequest request) {
        return this.listAssignmentsForHITAsync(request, null);
    }

    @Override
    public Future<ListAssignmentsForHITResult> listAssignmentsForHITAsync(final ListAssignmentsForHITRequest request, final AsyncHandler<ListAssignmentsForHITRequest, ListAssignmentsForHITResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAssignmentsForHITResult>(){

            @Override
            public ListAssignmentsForHITResult call() throws Exception {
                ListAssignmentsForHITResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listAssignmentsForHIT(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBonusPaymentsResult> listBonusPaymentsAsync(ListBonusPaymentsRequest request) {
        return this.listBonusPaymentsAsync(request, null);
    }

    @Override
    public Future<ListBonusPaymentsResult> listBonusPaymentsAsync(final ListBonusPaymentsRequest request, final AsyncHandler<ListBonusPaymentsRequest, ListBonusPaymentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListBonusPaymentsResult>(){

            @Override
            public ListBonusPaymentsResult call() throws Exception {
                ListBonusPaymentsResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listBonusPayments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHITsResult> listHITsAsync(ListHITsRequest request) {
        return this.listHITsAsync(request, null);
    }

    @Override
    public Future<ListHITsResult> listHITsAsync(final ListHITsRequest request, final AsyncHandler<ListHITsRequest, ListHITsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListHITsResult>(){

            @Override
            public ListHITsResult call() throws Exception {
                ListHITsResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listHITs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHITsForQualificationTypeResult> listHITsForQualificationTypeAsync(ListHITsForQualificationTypeRequest request) {
        return this.listHITsForQualificationTypeAsync(request, null);
    }

    @Override
    public Future<ListHITsForQualificationTypeResult> listHITsForQualificationTypeAsync(final ListHITsForQualificationTypeRequest request, final AsyncHandler<ListHITsForQualificationTypeRequest, ListHITsForQualificationTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListHITsForQualificationTypeResult>(){

            @Override
            public ListHITsForQualificationTypeResult call() throws Exception {
                ListHITsForQualificationTypeResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listHITsForQualificationType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQualificationRequestsResult> listQualificationRequestsAsync(ListQualificationRequestsRequest request) {
        return this.listQualificationRequestsAsync(request, null);
    }

    @Override
    public Future<ListQualificationRequestsResult> listQualificationRequestsAsync(final ListQualificationRequestsRequest request, final AsyncHandler<ListQualificationRequestsRequest, ListQualificationRequestsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListQualificationRequestsResult>(){

            @Override
            public ListQualificationRequestsResult call() throws Exception {
                ListQualificationRequestsResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listQualificationRequests(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQualificationTypesResult> listQualificationTypesAsync(ListQualificationTypesRequest request) {
        return this.listQualificationTypesAsync(request, null);
    }

    @Override
    public Future<ListQualificationTypesResult> listQualificationTypesAsync(final ListQualificationTypesRequest request, final AsyncHandler<ListQualificationTypesRequest, ListQualificationTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListQualificationTypesResult>(){

            @Override
            public ListQualificationTypesResult call() throws Exception {
                ListQualificationTypesResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listQualificationTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReviewPolicyResultsForHITResult> listReviewPolicyResultsForHITAsync(ListReviewPolicyResultsForHITRequest request) {
        return this.listReviewPolicyResultsForHITAsync(request, null);
    }

    @Override
    public Future<ListReviewPolicyResultsForHITResult> listReviewPolicyResultsForHITAsync(final ListReviewPolicyResultsForHITRequest request, final AsyncHandler<ListReviewPolicyResultsForHITRequest, ListReviewPolicyResultsForHITResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListReviewPolicyResultsForHITResult>(){

            @Override
            public ListReviewPolicyResultsForHITResult call() throws Exception {
                ListReviewPolicyResultsForHITResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listReviewPolicyResultsForHIT(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReviewableHITsResult> listReviewableHITsAsync(ListReviewableHITsRequest request) {
        return this.listReviewableHITsAsync(request, null);
    }

    @Override
    public Future<ListReviewableHITsResult> listReviewableHITsAsync(final ListReviewableHITsRequest request, final AsyncHandler<ListReviewableHITsRequest, ListReviewableHITsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListReviewableHITsResult>(){

            @Override
            public ListReviewableHITsResult call() throws Exception {
                ListReviewableHITsResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listReviewableHITs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkerBlocksResult> listWorkerBlocksAsync(ListWorkerBlocksRequest request) {
        return this.listWorkerBlocksAsync(request, null);
    }

    @Override
    public Future<ListWorkerBlocksResult> listWorkerBlocksAsync(final ListWorkerBlocksRequest request, final AsyncHandler<ListWorkerBlocksRequest, ListWorkerBlocksResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListWorkerBlocksResult>(){

            @Override
            public ListWorkerBlocksResult call() throws Exception {
                ListWorkerBlocksResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listWorkerBlocks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkersWithQualificationTypeResult> listWorkersWithQualificationTypeAsync(ListWorkersWithQualificationTypeRequest request) {
        return this.listWorkersWithQualificationTypeAsync(request, null);
    }

    @Override
    public Future<ListWorkersWithQualificationTypeResult> listWorkersWithQualificationTypeAsync(final ListWorkersWithQualificationTypeRequest request, final AsyncHandler<ListWorkersWithQualificationTypeRequest, ListWorkersWithQualificationTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListWorkersWithQualificationTypeResult>(){

            @Override
            public ListWorkersWithQualificationTypeResult call() throws Exception {
                ListWorkersWithQualificationTypeResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.listWorkersWithQualificationType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<NotifyWorkersResult> notifyWorkersAsync(NotifyWorkersRequest request) {
        return this.notifyWorkersAsync(request, null);
    }

    @Override
    public Future<NotifyWorkersResult> notifyWorkersAsync(final NotifyWorkersRequest request, final AsyncHandler<NotifyWorkersRequest, NotifyWorkersResult> asyncHandler) {
        return this.executorService.submit(new Callable<NotifyWorkersResult>(){

            @Override
            public NotifyWorkersResult call() throws Exception {
                NotifyWorkersResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.notifyWorkers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectAssignmentResult> rejectAssignmentAsync(RejectAssignmentRequest request) {
        return this.rejectAssignmentAsync(request, null);
    }

    @Override
    public Future<RejectAssignmentResult> rejectAssignmentAsync(final RejectAssignmentRequest request, final AsyncHandler<RejectAssignmentRequest, RejectAssignmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<RejectAssignmentResult>(){

            @Override
            public RejectAssignmentResult call() throws Exception {
                RejectAssignmentResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.rejectAssignment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectQualificationRequestResult> rejectQualificationRequestAsync(RejectQualificationRequestRequest request) {
        return this.rejectQualificationRequestAsync(request, null);
    }

    @Override
    public Future<RejectQualificationRequestResult> rejectQualificationRequestAsync(final RejectQualificationRequestRequest request, final AsyncHandler<RejectQualificationRequestRequest, RejectQualificationRequestResult> asyncHandler) {
        return this.executorService.submit(new Callable<RejectQualificationRequestResult>(){

            @Override
            public RejectQualificationRequestResult call() throws Exception {
                RejectQualificationRequestResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.rejectQualificationRequest(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendBonusResult> sendBonusAsync(SendBonusRequest request) {
        return this.sendBonusAsync(request, null);
    }

    @Override
    public Future<SendBonusResult> sendBonusAsync(final SendBonusRequest request, final AsyncHandler<SendBonusRequest, SendBonusResult> asyncHandler) {
        return this.executorService.submit(new Callable<SendBonusResult>(){

            @Override
            public SendBonusResult call() throws Exception {
                SendBonusResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.sendBonus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendTestEventNotificationResult> sendTestEventNotificationAsync(SendTestEventNotificationRequest request) {
        return this.sendTestEventNotificationAsync(request, null);
    }

    @Override
    public Future<SendTestEventNotificationResult> sendTestEventNotificationAsync(final SendTestEventNotificationRequest request, final AsyncHandler<SendTestEventNotificationRequest, SendTestEventNotificationResult> asyncHandler) {
        return this.executorService.submit(new Callable<SendTestEventNotificationResult>(){

            @Override
            public SendTestEventNotificationResult call() throws Exception {
                SendTestEventNotificationResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.sendTestEventNotification(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateExpirationForHITResult> updateExpirationForHITAsync(UpdateExpirationForHITRequest request) {
        return this.updateExpirationForHITAsync(request, null);
    }

    @Override
    public Future<UpdateExpirationForHITResult> updateExpirationForHITAsync(final UpdateExpirationForHITRequest request, final AsyncHandler<UpdateExpirationForHITRequest, UpdateExpirationForHITResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateExpirationForHITResult>(){

            @Override
            public UpdateExpirationForHITResult call() throws Exception {
                UpdateExpirationForHITResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.updateExpirationForHIT(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHITReviewStatusResult> updateHITReviewStatusAsync(UpdateHITReviewStatusRequest request) {
        return this.updateHITReviewStatusAsync(request, null);
    }

    @Override
    public Future<UpdateHITReviewStatusResult> updateHITReviewStatusAsync(final UpdateHITReviewStatusRequest request, final AsyncHandler<UpdateHITReviewStatusRequest, UpdateHITReviewStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateHITReviewStatusResult>(){

            @Override
            public UpdateHITReviewStatusResult call() throws Exception {
                UpdateHITReviewStatusResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.updateHITReviewStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHITTypeOfHITResult> updateHITTypeOfHITAsync(UpdateHITTypeOfHITRequest request) {
        return this.updateHITTypeOfHITAsync(request, null);
    }

    @Override
    public Future<UpdateHITTypeOfHITResult> updateHITTypeOfHITAsync(final UpdateHITTypeOfHITRequest request, final AsyncHandler<UpdateHITTypeOfHITRequest, UpdateHITTypeOfHITResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateHITTypeOfHITResult>(){

            @Override
            public UpdateHITTypeOfHITResult call() throws Exception {
                UpdateHITTypeOfHITResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.updateHITTypeOfHIT(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNotificationSettingsResult> updateNotificationSettingsAsync(UpdateNotificationSettingsRequest request) {
        return this.updateNotificationSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateNotificationSettingsResult> updateNotificationSettingsAsync(final UpdateNotificationSettingsRequest request, final AsyncHandler<UpdateNotificationSettingsRequest, UpdateNotificationSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateNotificationSettingsResult>(){

            @Override
            public UpdateNotificationSettingsResult call() throws Exception {
                UpdateNotificationSettingsResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.updateNotificationSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateQualificationTypeResult> updateQualificationTypeAsync(UpdateQualificationTypeRequest request) {
        return this.updateQualificationTypeAsync(request, null);
    }

    @Override
    public Future<UpdateQualificationTypeResult> updateQualificationTypeAsync(final UpdateQualificationTypeRequest request, final AsyncHandler<UpdateQualificationTypeRequest, UpdateQualificationTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateQualificationTypeResult>(){

            @Override
            public UpdateQualificationTypeResult call() throws Exception {
                UpdateQualificationTypeResult result;
                try {
                    result = AmazonMTurkAsyncClient.this.updateQualificationType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

